/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.EditSignMessage;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class SignEditingModule
extends QuarkModule {
    @Config
    public static boolean requiresEmptyHand = false;

    @OnlyIn(value=Dist.CLIENT)
    public static void openSignGuiClient(BlockPos pos) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(SignEditingModule.class)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        TileEntity tile = mc.field_71441_e.func_175625_s(pos);
        if (tile instanceof SignTileEntity) {
            mc.field_71439_g.func_175141_a((SignTileEntity)tile);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!(!(player instanceof ServerPlayerEntity) || !(tile instanceof SignTileEntity) || this.doesSignHaveCommand((SignTileEntity)tile) || requiresEmptyHand && !stack.func_190926_b() || stack.func_77973_b() instanceof DyeItem || tile.func_195044_w().func_177230_c().getRegistryName().func_110624_b().equals("signbutton") || !player.func_175151_a(event.getPos(), event.getFace(), event.getItemStack()) || event.getEntity().func_226273_bm_())) {
            SignTileEntity sign = (SignTileEntity)tile;
            sign.func_145912_a(player);
            sign.field_145916_j = true;
            QuarkNetwork.sendToPlayer(new EditSignMessage(event.getPos()), (ServerPlayerEntity)player);
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    private boolean doesSignHaveCommand(SignTileEntity sign) {
        for (ITextComponent itextcomponent : sign.field_145915_a) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = itextcomponent == null ? null : itextcomponent.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            return true;
        }
        return false;
    }
}

