/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.api.config.IConfigObject;
import vazkii.quark.base.client.config.ConfigCategory;
import vazkii.quark.base.client.config.gui.CategoryScreen;
import vazkii.quark.base.client.config.gui.widget.IWidgetProvider;
import vazkii.quark.base.client.config.gui.widget.ScrollableWidgetList;
import vazkii.quark.base.client.handler.TopLayerTooltipHandler;

public class ConfigElementList<T extends IConfigElement & IWidgetProvider>
extends ScrollableWidgetList<CategoryScreen, Entry<T>> {
    public ConfigElementList(CategoryScreen parent) {
        super(parent);
    }

    @Override
    protected void findEntries() {
        boolean hadObjects = false;
        boolean isObject = true;
        for (IConfigElement elm : ((CategoryScreen)this.parent).category.getSubElements()) {
            boolean wasObject = isObject;
            isObject = elm instanceof IConfigObject;
            if (wasObject && !isObject && hadObjects) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new Entry<Object>((CategoryScreen)this.parent, null));
            }
            Entry<IConfigElement> entry = new Entry<IConfigElement>((CategoryScreen)this.parent, elm);
            this.func_230513_b_((AbstractList.AbstractListEntry)entry);
            hadObjects = hadObjects || isObject;
        }
    }

    public static final class Entry<T extends IConfigElement & IWidgetProvider>
    extends ScrollableWidgetList.Entry<Entry<T>> {
        private final T element;

        public Entry(CategoryScreen parent, T element) {
            this.element = element;
            if (element != null) {
                ((IWidgetProvider)element).addWidgets(parent, this.children);
            }
        }

        @Override
        public void func_230432_a_(MatrixStack mstack, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float pticks) {
            super.func_230432_a_(mstack, index, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered, pticks);
            Minecraft mc = Minecraft.func_71410_x();
            if (this.element != null) {
                int left = rowLeft + 10;
                int top = rowTop + 4;
                int effIndex = index + 1;
                if (this.element instanceof ConfigCategory) {
                    --effIndex;
                }
                this.drawBackground(mstack, effIndex, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered);
                String name = this.element.getGuiDisplayName();
                if (this.element.isDirty()) {
                    name = name + TextFormatting.GOLD + "*";
                }
                int len = mc.field_71466_p.func_78256_a(name);
                int maxLen = rowWidth - 85;
                String originalName = null;
                if (len > maxLen) {
                    originalName = name;
                    while ((len = mc.field_71466_p.func_78256_a(name = name.substring(0, name.length() - 1))) > maxLen) {
                    }
                    name = name + "...";
                }
                List<String> tooltip = this.element.getTooltip();
                if (originalName != null) {
                    if (tooltip == null) {
                        tooltip = new LinkedList<String>();
                        tooltip.add(originalName);
                    } else {
                        tooltip.add(0, "");
                        tooltip.add(0, originalName);
                    }
                }
                if (tooltip != null) {
                    int hoverLeft = left + mc.field_71466_p.func_78256_a(name + " ");
                    int hoverRight = hoverLeft + mc.field_71466_p.func_78256_a("(?)");
                    name = name + TextFormatting.AQUA + " (?)";
                    if (mouseX >= hoverLeft && mouseX < hoverRight && mouseY >= top && mouseY < top + 10) {
                        TopLayerTooltipHandler.setTooltip(tooltip, mouseX, mouseY);
                    }
                }
                mc.field_71466_p.func_238405_a_(mstack, name, (float)left, (float)top, 0xFFFFFF);
                mc.field_71466_p.func_238405_a_(mstack, ((IWidgetProvider)this.element).getSubtitle(), (float)left, (float)(top + 10), 0x999999);
            } else {
                String s = I18n.func_135052_a((String)"quark.gui.config.subcategories", (Object[])new Object[0]);
                mc.field_71466_p.func_238405_a_(mstack, s, (float)(rowLeft + (rowWidth - mc.field_71466_p.func_78256_a(s)) / 2), (float)(rowTop + 7), 0x6666FF);
            }
        }
    }
}

