/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mgui.gui;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import se.mickelus.mgui.gui.GuiClickable;
import se.mickelus.mgui.gui.GuiStringOutline;

public class GuiButton
extends GuiClickable {
    private final GuiStringOutline textElement;
    private boolean enabled = true;
    private String disabledTooltip;

    public GuiButton(int x, int y, int width, int height, String text, Runnable onClick) {
        super(x, y, width, height, onClick);
        this.textElement = new GuiStringOutline(0, (height - 8) / 2, text);
        this.addChild(this.textElement);
    }

    public GuiButton(int x, int y, String text, Runnable onClick) {
        this(x, y, Minecraft.func_71410_x().field_71466_p.func_78256_a(text), 10, text, onClick);
    }

    public GuiButton(int x, int y, int width, int height, String text, Runnable onClick, String disabledTooltip) {
        this(x, y, width, height, text, onClick);
        this.disabledTooltip = disabledTooltip;
    }

    @Override
    public boolean onMouseClick(int x, int y, int button) {
        return this.enabled && super.onMouseClick(x, y, button);
    }

    private void updateColor() {
        if (!this.enabled) {
            this.textElement.setColor(0x7F7F7F);
        } else if (this.hasFocus()) {
            this.textElement.setColor(0xFFFFCC);
        } else {
            this.textElement.setColor(0xFFFFFF);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateColor();
    }

    public void setText(String text) {
        this.textElement.setString(text);
        this.setWidth(Minecraft.func_71410_x().field_71466_p.func_78256_a(text));
    }

    @Override
    protected void onFocus() {
        this.updateColor();
    }

    @Override
    protected void onBlur() {
        this.updateColor();
    }

    @Override
    public List<String> getTooltipLines() {
        if (!this.enabled && this.disabledTooltip != null && this.hasFocus()) {
            return Collections.singletonList(this.disabledTooltip);
        }
        return null;
    }
}

