/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.biome.BiomeMetadata;
import biomesoplenty.common.biome.BiomeRegistry;
import biomesoplenty.common.biome.BiomeTemplate;
import biomesoplenty.common.biome.nether.CrystallineChasmBiome;
import biomesoplenty.common.biome.nether.UndergrowthBiome;
import biomesoplenty.common.biome.nether.VisceralHeapBiome;
import biomesoplenty.common.biome.nether.WitheredAbyssBiome;
import biomesoplenty.common.biome.overworld.AlpsBiome;
import biomesoplenty.common.biome.overworld.AlpsFoothillsBiome;
import biomesoplenty.common.biome.overworld.BambooBlossomGroveBiome;
import biomesoplenty.common.biome.overworld.BayouBiome;
import biomesoplenty.common.biome.overworld.BayouMangroveBiome;
import biomesoplenty.common.biome.overworld.BurntForestBiome;
import biomesoplenty.common.biome.overworld.CherryBlossomGroveBiome;
import biomesoplenty.common.biome.overworld.ColdDesertBiome;
import biomesoplenty.common.biome.overworld.ConiferousForestBiome;
import biomesoplenty.common.biome.overworld.ConiferousLakesBiome;
import biomesoplenty.common.biome.overworld.DeadForestBiome;
import biomesoplenty.common.biome.overworld.DeepBayouBiome;
import biomesoplenty.common.biome.overworld.DenseMarshBiome;
import biomesoplenty.common.biome.overworld.DenseWoodlandBiome;
import biomesoplenty.common.biome.overworld.DryBoneyardBiome;
import biomesoplenty.common.biome.overworld.DrylandBiome;
import biomesoplenty.common.biome.overworld.FirClearingBiome;
import biomesoplenty.common.biome.overworld.FlowerMeadowBiome;
import biomesoplenty.common.biome.overworld.FungalFieldBiome;
import biomesoplenty.common.biome.overworld.FungalJungleBiome;
import biomesoplenty.common.biome.overworld.GoldenPrairieBiome;
import biomesoplenty.common.biome.overworld.GrasslandBiome;
import biomesoplenty.common.biome.overworld.GrasslandCloverPatchBiome;
import biomesoplenty.common.biome.overworld.GravelBeachBiome;
import biomesoplenty.common.biome.overworld.GroveBiome;
import biomesoplenty.common.biome.overworld.GroveClearingBiome;
import biomesoplenty.common.biome.overworld.GroveLakesBiome;
import biomesoplenty.common.biome.overworld.HighlandBiome;
import biomesoplenty.common.biome.overworld.HighlandCragBiome;
import biomesoplenty.common.biome.overworld.HighlandMoorBiome;
import biomesoplenty.common.biome.overworld.JadeCliffsBiome;
import biomesoplenty.common.biome.overworld.LavenderFieldBiome;
import biomesoplenty.common.biome.overworld.LavenderForestBiome;
import biomesoplenty.common.biome.overworld.LushDesertBiome;
import biomesoplenty.common.biome.overworld.LushSavannaBiome;
import biomesoplenty.common.biome.overworld.MarshBiome;
import biomesoplenty.common.biome.overworld.MeadowBiome;
import biomesoplenty.common.biome.overworld.MeadowForestBiome;
import biomesoplenty.common.biome.overworld.MuskegBiome;
import biomesoplenty.common.biome.overworld.MysticGroveBiome;
import biomesoplenty.common.biome.overworld.MysticPlainsBiome;
import biomesoplenty.common.biome.overworld.OminousMireBiome;
import biomesoplenty.common.biome.overworld.OminousWoodsBiome;
import biomesoplenty.common.biome.overworld.OrchardBiome;
import biomesoplenty.common.biome.overworld.OriginValleyBiome;
import biomesoplenty.common.biome.overworld.PrairieBiome;
import biomesoplenty.common.biome.overworld.RainbowHillsBiome;
import biomesoplenty.common.biome.overworld.RainforestBiome;
import biomesoplenty.common.biome.overworld.RainforestCliffsBiome;
import biomesoplenty.common.biome.overworld.RainforestFloodplainBiome;
import biomesoplenty.common.biome.overworld.RedwoodForestBiome;
import biomesoplenty.common.biome.overworld.RedwoodForestEdgeBiome;
import biomesoplenty.common.biome.overworld.RedwoodHillsBiome;
import biomesoplenty.common.biome.overworld.ScrublandBiome;
import biomesoplenty.common.biome.overworld.SeasonalForestBiome;
import biomesoplenty.common.biome.overworld.SeasonalOrchardBiome;
import biomesoplenty.common.biome.overworld.SeasonalPumpkinPatchBiome;
import biomesoplenty.common.biome.overworld.ShroomyWetlandBiome;
import biomesoplenty.common.biome.overworld.ShrublandBiome;
import biomesoplenty.common.biome.overworld.ShrublandHillsBiome;
import biomesoplenty.common.biome.overworld.SnowyConiferousForestBiome;
import biomesoplenty.common.biome.overworld.SnowyFirClearingBiome;
import biomesoplenty.common.biome.overworld.SnowyMapleForestBiome;
import biomesoplenty.common.biome.overworld.TallDeadForestBiome;
import biomesoplenty.common.biome.overworld.TropicBeachBiome;
import biomesoplenty.common.biome.overworld.TropicsBiome;
import biomesoplenty.common.biome.overworld.TundraBasinBiome;
import biomesoplenty.common.biome.overworld.TundraBiome;
import biomesoplenty.common.biome.overworld.TundraBogBiome;
import biomesoplenty.common.biome.overworld.VolcanicPlainsBiome;
import biomesoplenty.common.biome.overworld.VolcanoBiome;
import biomesoplenty.common.biome.overworld.WastelandBiome;
import biomesoplenty.common.biome.overworld.WetlandBiome;
import biomesoplenty.common.biome.overworld.WetlandForestBiome;
import biomesoplenty.common.biome.overworld.WoodedScrublandBiome;
import biomesoplenty.common.biome.overworld.WoodlandBiome;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPBiomeProvider;
import biomesoplenty.common.world.BOPNetherBiomeProvider;
import biomesoplenty.common.world.BOPWorldType;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.level.ColorResolver;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    public static BOPWorldType bopWorldType = new BOPWorldType();
    public static Multimap<Integer, WeightedSubBiome> subBiomes = HashMultimap.create();
    public static List<Integer> islandBiomeIds = Lists.newArrayList();
    public static Map<RegistryKey<Biome>, BiomeMetadata> biomeMetadata = Maps.newHashMap();

    public static void setup() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ColorResolver grassColorResolver = BiomeColors.field_180291_a;
            ColorResolver foliageColorResolver = BiomeColors.field_180289_b;
            ColorResolver waterColorResolver = BiomeColors.field_180290_c;
            BiomeColors.field_180291_a = (biome, posX, posZ) -> {
                RegistryKey<Biome> key = BiomeUtil.getClientKey(biome);
                BiomeMetadata meta = BiomeUtil.getMetadata(key);
                if (meta != null && meta.getGrassColorFunction() != null) {
                    return meta.getGrassColorFunction().apply(posX, posZ);
                }
                return grassColorResolver.getColor(biome, posX, posZ);
            };
            BiomeColors.field_180289_b = (biome, posX, posZ) -> {
                RegistryKey<Biome> key = BiomeUtil.getClientKey(biome);
                BiomeMetadata meta = BiomeUtil.getMetadata(key);
                if (meta != null && meta.getFoliageColorFunction() != null) {
                    return meta.getFoliageColorFunction().apply(posX, posZ);
                }
                return foliageColorResolver.getColor(biome, posX, posZ);
            };
            BiomeColors.field_180290_c = (biome, posX, posZ) -> {
                RegistryKey<Biome> key = BiomeUtil.getClientKey(biome);
                BiomeMetadata meta = BiomeUtil.getMetadata(key);
                if (meta != null && meta.getWaterColorFunction() != null) {
                    return meta.getWaterColorFunction().apply(posX, posZ);
                }
                return waterColorResolver.getColor(biome, posX, posZ);
            };
        }
        Logger gameDataLogger = (Logger)LogManager.getLogger(GameData.class);
        Level oldLevel = gameDataLogger.getLevel();
        gameDataLogger.setLevel(Level.OFF);
        bopWorldType.setRegistryName(new ResourceLocation("biomesoplenty"));
        ForgeRegistries.WORLD_TYPES.register((IForgeRegistryEntry)bopWorldType);
        gameDataLogger.setLevel(oldLevel);
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"biomesoplenty_overworld", BOPBiomeProvider.CODEC);
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"biomesoplenty_nether", BOPNetherBiomeProvider.CODEC);
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.registerTechnicalBiome(new GravelBeachBiome(), "gravel_beach");
        ModBiomes.registerTechnicalBiome(new TropicBeachBiome(), "tropic_beach");
        ModBiomes.registerTechnicalBiome(new AlpsFoothillsBiome(), "alps_foothills");
        ModBiomes.registerTechnicalBiome(new RedwoodForestEdgeBiome(), "redwood_forest_edge");
        ModBiomes.registerTechnicalBiome(new VolcanicPlainsBiome(), "volcanic_plains");
        ModBiomes.registerTechnicalBiome(new OrchardBiome(), "orchard");
        BiomeRegistry.configureTechnicalBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.TECHNICAL_BIOME);
        ModBiomes.registerBiome(new BayouMangroveBiome(), "bayou_mangrove");
        ModBiomes.registerBiome(new AlpsBiome(), "alps");
        ModBiomes.registerBiome(new BambooBlossomGroveBiome(), "bamboo_blossom_grove");
        ModBiomes.registerBiome(new BayouBiome(), "bayou");
        ModBiomes.registerBiome(new BurntForestBiome(), "burnt_forest");
        ModBiomes.registerBiome(new CherryBlossomGroveBiome(), "cherry_blossom_grove");
        ModBiomes.registerBiome(new ColdDesertBiome(), "cold_desert");
        ModBiomes.registerBiome(new ConiferousForestBiome(), "coniferous_forest");
        ModBiomes.registerBiome(new ConiferousLakesBiome(), "coniferous_lakes");
        ModBiomes.registerBiome(new DeadForestBiome(), "dead_forest");
        ModBiomes.registerBiome(new DeepBayouBiome(), "deep_bayou");
        ModBiomes.registerBiome(new DenseMarshBiome(), "dense_marsh");
        ModBiomes.registerBiome(new DenseWoodlandBiome(), "dense_woodland");
        ModBiomes.registerBiome(new DrylandBiome(), "dryland");
        ModBiomes.registerBiome(new DryBoneyardBiome(), "dry_boneyard");
        ModBiomes.registerBiome(new FirClearingBiome(), "fir_clearing");
        ModBiomes.registerBiome(new FlowerMeadowBiome(), "flower_meadow");
        ModBiomes.registerBiome(new FungalFieldBiome(), "fungal_field");
        ModBiomes.registerBiome(new FungalJungleBiome(), "fungal_jungle");
        ModBiomes.registerBiome(new GoldenPrairieBiome(), "golden_prairie");
        ModBiomes.registerBiome(new GrasslandBiome(), "grassland");
        ModBiomes.registerBiome(new GrasslandCloverPatchBiome(), "grassland_clover_patch");
        ModBiomes.registerBiome(new GroveBiome(), "grove");
        ModBiomes.registerBiome(new GroveClearingBiome(), "grove_clearing");
        ModBiomes.registerBiome(new GroveLakesBiome(), "grove_lakes");
        ModBiomes.registerBiome(new HighlandBiome(), "highland");
        ModBiomes.registerBiome(new HighlandCragBiome(), "highland_crag");
        ModBiomes.registerBiome(new HighlandMoorBiome(), "highland_moor");
        ModBiomes.registerBiome(new JadeCliffsBiome(), "jade_cliffs");
        ModBiomes.registerBiome(new LavenderFieldBiome(), "lavender_field");
        ModBiomes.registerBiome(new LavenderForestBiome(), "lavender_forest");
        ModBiomes.registerBiome(new LushDesertBiome(), "lush_desert");
        ModBiomes.registerBiome(new LushSavannaBiome(), "lush_savanna");
        ModBiomes.registerBiome(new MarshBiome(), "marsh");
        ModBiomes.registerBiome(new MeadowBiome(), "meadow");
        ModBiomes.registerBiome(new MeadowForestBiome(), "meadow_forest");
        ModBiomes.registerBiome(new MuskegBiome(), "muskeg");
        ModBiomes.registerBiome(new MysticGroveBiome(), "mystic_grove");
        ModBiomes.registerBiome(new MysticPlainsBiome(), "mystic_plains");
        ModBiomes.registerBiome(new OminousWoodsBiome(), "ominous_woods");
        ModBiomes.registerBiome(new OminousMireBiome(), "ominous_mire");
        ModBiomes.registerBiome(new OriginValleyBiome(), "origin_valley");
        ModBiomes.registerBiome(new PrairieBiome(), "prairie");
        ModBiomes.registerBiome(new RainbowHillsBiome(), "rainbow_hills");
        ModBiomes.registerBiome(new RainforestBiome(), "rainforest");
        ModBiomes.registerBiome(new RainforestCliffsBiome(), "rainforest_cliffs");
        ModBiomes.registerBiome(new RainforestFloodplainBiome(), "rainforest_floodplain");
        ModBiomes.registerBiome(new RedwoodForestBiome(), "redwood_forest");
        ModBiomes.registerBiome(new RedwoodHillsBiome(), "redwood_hills");
        ModBiomes.registerBiome(new ScrublandBiome(), "scrubland");
        ModBiomes.registerBiome(new SeasonalForestBiome(), "seasonal_forest");
        ModBiomes.registerBiome(new SeasonalOrchardBiome(), "seasonal_orchard");
        ModBiomes.registerBiome(new SeasonalPumpkinPatchBiome(), "seasonal_pumpkin_patch");
        ModBiomes.registerBiome(new ShroomyWetlandBiome(), "shroomy_wetland");
        ModBiomes.registerBiome(new ShrublandBiome(), "shrubland");
        ModBiomes.registerBiome(new ShrublandHillsBiome(), "shrubland_hills");
        ModBiomes.registerBiome(new SnowyConiferousForestBiome(), "snowy_coniferous_forest");
        ModBiomes.registerBiome(new SnowyMapleForestBiome(), "snowy_maple_forest");
        ModBiomes.registerBiome(new SnowyFirClearingBiome(), "snowy_fir_clearing");
        ModBiomes.registerBiome(new TallDeadForestBiome(), "tall_dead_forest");
        ModBiomes.registerBiome(new TropicsBiome(), "tropics");
        ModBiomes.registerBiome(new TundraBiome(), "tundra");
        ModBiomes.registerBiome(new TundraBasinBiome(), "tundra_basin");
        ModBiomes.registerBiome(new TundraBogBiome(), "tundra_bog");
        ModBiomes.registerBiome(new VolcanoBiome(), "volcano");
        ModBiomes.registerBiome(new WastelandBiome(), "wasteland");
        ModBiomes.registerBiome(new WetlandBiome(), "wetland");
        ModBiomes.registerBiome(new WetlandForestBiome(), "wetland_forest");
        ModBiomes.registerBiome(new WoodedScrublandBiome(), "wooded_scrubland");
        ModBiomes.registerBiome(new WoodlandBiome(), "woodland");
        ModBiomes.registerBiome(new CrystallineChasmBiome(), "crystalline_chasm");
        ModBiomes.registerBiome(new UndergrowthBiome(), "undergrowth");
        ModBiomes.registerBiome(new VisceralHeapBiome(), "visceral_heap");
        ModBiomes.registerBiome(new WitheredAbyssBiome(), "withered_abyss");
        BiomeRegistry.configureStandardBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.STANDARD_BIOME);
        ModBiomes.registerSubBiome(BOPBiomes.bayou, BOPBiomes.deep_bayou, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.bayou, BOPBiomes.bayou_mangrove, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.cherry_blossom_grove, BOPBiomes.bamboo_blossom_grove, 0.8f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.coniferous_forest, BOPBiomes.fir_clearing, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.coniferous_forest, BOPBiomes.coniferous_lakes, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.dead_forest, BOPBiomes.tall_dead_forest, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.dead_forest, BOPBiomes.burnt_forest, 0.6f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.dryland, BOPBiomes.dry_boneyard, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.fungal_jungle, BOPBiomes.fungal_field, 0.9f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.grassland, BOPBiomes.grassland_clover_patch, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.grove, BOPBiomes.grove_clearing, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.grove, BOPBiomes.grove_lakes, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.highland, BOPBiomes.highland_crag, 1.25f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.highland, BOPBiomes.highland_moor, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.lavender_field, BOPBiomes.lavender_forest, 0.6f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.lush_desert, BOPBiomes.lush_savanna, 0.65f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.marsh, BOPBiomes.dense_marsh, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.meadow, BOPBiomes.flower_meadow, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.meadow, BOPBiomes.meadow_forest, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.mystic_grove, BOPBiomes.mystic_plains, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.ominous_woods, BOPBiomes.ominous_mire, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.prairie, BOPBiomes.golden_prairie, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.rainforest, BOPBiomes.rainforest_cliffs, 2.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.rainforest, BOPBiomes.rainforest_floodplain, 2.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.redwood_forest, BOPBiomes.redwood_hills, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.scrubland, BOPBiomes.wooded_scrubland, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.seasonal_forest, BOPBiomes.seasonal_orchard, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.seasonal_forest, BOPBiomes.seasonal_pumpkin_patch, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.shrubland, BOPBiomes.shrubland_hills, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.snowy_coniferous_forest, BOPBiomes.snowy_fir_clearing, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.snowy_coniferous_forest, BOPBiomes.snowy_maple_forest, 1.25f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.tundra, BOPBiomes.tundra_basin, 1.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.tundra, BOPBiomes.tundra_bog, 2.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.wetland, BOPBiomes.wetland_forest, 1.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.wetland, BOPBiomes.shroomy_wetland, 1.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.woodland, BOPBiomes.dense_woodland, 0.9f, 100);
        BiomeRegistry.configureSubBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.SUB_BIOME);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_valley, BOPClimates.COOL_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_valley, BOPClimates.DRY_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_valley, BOPClimates.WET_TEMPERATE, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.WARM_TEMPERATE, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.MEDITERRANEAN, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.SAVANNA, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_hills, BOPClimates.WET_TEMPERATE, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_hills, BOPClimates.WARM_TEMPERATE, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_hills, BOPClimates.MEDITERRANEAN, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.SUBTROPICAL, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.TROPICAL, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.HOT_DESERT, 50);
        BiomeRegistry.configureIslandBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.ISLAND_BIOME);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76774_n, BOPClimates.ICE_CAP, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76776_l, BOPClimates.ICE_CAP, 3);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76770_e, BOPClimates.TUNDRA, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150584_S, BOPClimates.TUNDRA, 7);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76768_g, BOPClimates.WET_BOREAL, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150578_U, BOPClimates.DRY_BOREAL, 5);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150585_R, BOPClimates.WET_TEMPERATE, 7);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150583_P, BOPClimates.DRY_TEMPERATE, 5);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76767_f, BOPClimates.COOL_TEMPERATE, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76772_c, BOPClimates.WARM_TEMPERATE, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76780_h, BOPClimates.SUBTROPICAL, 7);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_203615_U, BOPClimates.SUBTROPICAL, 3);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76782_w, BOPClimates.TROPICAL, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150588_X, BOPClimates.SAVANNA, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76769_d, BOPClimates.HOT_DESERT, 15);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150608_ab, BOPClimates.HOT_DESERT, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150607_aa, BOPClimates.HOT_DESERT, 3);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235251_aB_, BOPClimates.NETHER, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235253_az_, BOPClimates.NETHER, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235254_j_, BOPClimates.NETHER, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235252_ay_, BOPClimates.NETHER, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235250_aA_, BOPClimates.NETHER, 10);
        BiomeRegistry.configureVanillaBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.VANILLA_BIOME);
        ModBiomes.registerBiomeDictionaryTags();
        ModBiomes.registerVillagerTypes();
    }

    private static void registerBiomeDictionaryTags() {
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps_foothills, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bamboo_blossom_grove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bayou, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bayou_mangrove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.burnt_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cherry_blossom_grove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cold_desert, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.coniferous_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.coniferous_lakes, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dead_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.deep_bayou, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dense_marsh, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dense_woodland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dryland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SANDY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dry_boneyard, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fir_clearing, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.flower_meadow, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fungal_field, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.RARE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fungal_jungle, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.golden_prairie, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.gravel_beach, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.BEACH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grassland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grassland_clover_patch, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grove_clearing, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grove_lakes, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland_crag, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland_moor, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.jade_cliffs, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lavender_field, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lavender_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_desert, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.SANDY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_savanna, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.marsh, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.meadow, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.meadow_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.muskeg, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mystic_grove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mystic_plains, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ominous_mire, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ominous_woods, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.orchard, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.origin_valley, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.prairie, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainbow_hills, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainforest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainforest_cliffs, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLATEAU);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainforest_floodplain, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_forest_edge, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_hills, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.scrubland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.seasonal_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.seasonal_orchard, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.seasonal_pumpkin_patch, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shroomy_wetland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.MUSHROOM);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shrubland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shrubland_hills, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_coniferous_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_fir_clearing, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_maple_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tall_dead_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropic_beach, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SANDY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropics, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tundra, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tundra_basin, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tundra_bog, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.volcanic_plains, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.volcano, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wasteland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wetland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wetland_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wooded_scrubland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.woodland, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.crystalline_chasm, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.MAGICAL);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.undergrowth, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.visceral_heap, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.withered_abyss, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.VOID);
    }

    private static void registerVillagerTypes() {
        ModBiomes.registerVillagerType(BOPBiomes.alps, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.alps_foothills, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.bamboo_blossom_grove, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.bayou, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.bayou_mangrove, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.burnt_forest, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.cherry_blossom_grove, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.cold_desert, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.coniferous_forest, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.coniferous_lakes, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.dead_forest, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.deep_bayou, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.dense_marsh, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.dense_woodland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.dryland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.dry_boneyard, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.fir_clearing, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.flower_meadow, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.fungal_field, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.fungal_jungle, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.golden_prairie, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.grassland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.grassland_clover_patch, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.gravel_beach, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.grove, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.grove_clearing, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.grove_lakes, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.highland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.highland_crag, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.highland_moor, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.jade_cliffs, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.lavender_field, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.lavender_forest, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.lush_desert, VillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.lush_savanna, VillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.marsh, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.meadow, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.meadow_forest, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.muskeg, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.mystic_grove, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.mystic_plains, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.ominous_mire, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.ominous_woods, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.orchard, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.origin_valley, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.prairie, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.rainbow_hills, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.rainforest, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.rainforest_cliffs, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.rainforest_floodplain, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.redwood_forest, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.redwood_forest_edge, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.redwood_hills, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.scrubland, VillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.seasonal_forest, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.seasonal_orchard, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.seasonal_pumpkin_patch, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.shroomy_wetland, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.shrubland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.shrubland_hills, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_coniferous_forest, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_fir_clearing, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_maple_forest, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.tall_dead_forest, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.tropic_beach, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.tropics, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.tundra, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.tundra_basin, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.tundra_bog, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.volcanic_plains, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.volcano, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.wasteland, VillagerType.field_221173_a);
        ModBiomes.registerVillagerType(BOPBiomes.wetland, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.wetland_forest, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.wooded_scrubland, VillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.woodland, VillagerType.field_221175_c);
    }

    private static void registerBiomeToDictionary(RegistryKey<Biome> key, BiomeDictionary.Type ... type) {
        if (BiomeUtil.exists(key)) {
            BiomeDictionary.addTypes(key, (BiomeDictionary.Type[])type);
        }
    }

    private static void registerVillagerType(RegistryKey<Biome> key, VillagerType type) {
        if (BiomeUtil.exists(key)) {
            VillagerType.field_221180_h.put(key, type);
        }
    }

    public static void registerBiome(BiomeTemplate biome, String name) {
        BiomeRegistry.deferStandardRegistration(biome, name);
    }

    public static void registerTechnicalBiome(BiomeTemplate biome, String name) {
        BiomeRegistry.deferTechnicalBiomeRegistration(biome, name);
    }

    public static void registerSubBiome(RegistryKey<Biome> parent, RegistryKey<Biome> child, float rarity, int weight) {
        BiomeRegistry.deferSubBiomeRegistration(parent, child, weight, rarity);
    }

    public static void registerIslandBiome(RegistryKey<Biome> key, BOPClimates climate, int weight) {
        BiomeRegistry.deferIslandBiomeRegistration(key, climate, weight);
    }

    private static void registerVanillaBiome(RegistryKey<Biome> key, BOPClimates climate, int weight) {
        BiomeRegistry.deferVanillaBiomeRegistration(key, climate, weight);
    }

    public static class WeightedSubBiome {
        public final RegistryKey<Biome> biome;
        public final float rarity;
        public final int weight;

        public WeightedSubBiome(RegistryKey<Biome> biome, float rarity, int weight) {
            this.biome = biome;
            this.rarity = rarity;
            this.weight = weight;
        }
    }
}

