/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.NetherCrystalBlock;
import biomesoplenty.common.util.block.IBlockPosQuery;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LargeCrystalFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).func_177230_c() == Blocks.field_150424_aL;
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos) || world.func_180495_p(pos).func_177230_c() == BOPBlocks.nether_crystal;
    private int minRadius = 2;
    private int maxRadius = 3;
    private int minHeight = 3;
    private int maxHeight = 15;

    public LargeCrystalFeature(Codec<NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(ISeedReader world, ChunkGenerator p_230362_3_, Random rand, BlockPos pos, NoFeatureConfig p_230362_6_) {
        if (!world.func_175623_d(pos)) {
            return false;
        }
        BlockState blockstate = world.func_180495_p(pos.func_177984_a());
        if (!(blockstate.func_203425_a(Blocks.field_150424_aL) || blockstate.func_203425_a(Blocks.field_235337_cO_) || blockstate.func_203425_a(Blocks.field_235406_np_) || blockstate.func_203425_a(Blocks.field_196766_fg))) {
            return false;
        }
        int randRadius = this.minRadius + rand.nextInt(this.maxRadius - this.minRadius);
        int height = this.minHeight + rand.nextInt(this.maxHeight - this.minHeight);
        for (int y = 0; y <= height; ++y) {
            int radius = randRadius * (height - y) / height + 1;
            int radiusStart = MathHelper.func_76143_f((double)(0.25 - (double)radius / 2.0));
            int radiusEnd = MathHelper.func_76128_c((double)(0.25 + (double)radius / 2.0));
            for (int x = radiusStart; x <= radiusEnd; ++x) {
                for (int z = radiusStart; z <= radiusEnd; ++z) {
                    this.setBlock((IWorld)world, pos.func_177982_a(x, -y, z), BOPBlocks.nether_crystal_block.func_176223_P());
                }
            }
            this.generateCrystals(world, pos.func_177982_a(0, -y, 0), rand);
        }
        return true;
    }

    public boolean generateCrystals(ISeedReader world, BlockPos pos, Random rand) {
        int i = 0;
        for (int j = 0; j < 48; ++j) {
            AttachFace face;
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            switch (rand.nextInt(3)) {
                default: {
                    face = AttachFace.FLOOR;
                    break;
                }
                case 1: {
                    face = AttachFace.CEILING;
                    break;
                }
                case 2: {
                    face = AttachFace.WALL;
                }
            }
            BlockState state = (BlockState)((BlockState)BOPBlocks.nether_crystal.func_176223_P().func_206870_a((Property)NetherCrystalBlock.field_185512_D, (Comparable)direction)).func_206870_a((Property)NetherCrystalBlock.field_196366_M, (Comparable)face);
            BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - rand.nextInt(3), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - rand.nextInt(3));
            if (!world.func_175623_d(blockpos) || !state.func_196955_c((IWorldReader)world, blockpos)) continue;
            world.func_180501_a(blockpos, state, 2);
            ++i;
        }
        return i > 0;
    }

    public boolean setBlock(IWorld world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.func_230367_a_((IWorldWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(IWorld world, BlockPos pos) {
        for (int y = 0; y <= 15; --y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

