/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.WorldCacheIOThread;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;

public class WorldCacheManager
implements ITickHandler {
    private static final String DEFAULT_DOMAIN_NAME = "worlddata";
    private static final WorldCacheManager instance = new WorldCacheManager();
    private static final Map<ResourceLocation, WorldCacheDomain> domains = new HashMap<ResourceLocation, WorldCacheDomain>();

    private WorldCacheManager() {
    }

    public static WorldCacheManager getInstance() {
        return instance;
    }

    public static void scheduleSaveAll() {
        for (WorldCacheDomain domain : domains.values()) {
            for (ResourceLocation dimTypeName : domain.getUsedWorlds()) {
                for (WorldCacheDomain.SaveKey<? extends CachedWorldData> key : domain.getKnownSaveKeys()) {
                    CachedWorldData data = domain.getCachedData(dimTypeName, key);
                    if (data == null || !data.needsSaving()) continue;
                    WorldCacheIOThread.scheduleSave(domain, dimTypeName, data);
                }
            }
        }
    }

    public static void cleanUp() {
        for (WorldCacheDomain domain : domains.values()) {
            domain.clear();
        }
    }

    @Nonnull
    public static WorldCacheDomain createDomain(String modid) {
        ResourceLocation domainKey = new ResourceLocation(modid, DEFAULT_DOMAIN_NAME);
        WorldCacheDomain domain = new WorldCacheDomain(domainKey);
        domains.put(domainKey, domain);
        return domain;
    }

    @Nullable
    public static WorldCacheDomain findDomain(String modid) {
        ResourceLocation domainKey = new ResourceLocation(modid, DEFAULT_DOMAIN_NAME);
        for (ResourceLocation key : domains.keySet()) {
            if (!key.equals((Object)domainKey)) continue;
            return domains.get(key);
        }
        return null;
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        World world = (World)context[0];
        if (world.field_72995_K) {
            return;
        }
        for (WorldCacheDomain domain : domains.values()) {
            domain.tick(world);
        }
    }

    public void doSave(World world) {
        ResourceLocation worldName = world.func_234923_W_().func_240901_a_();
        for (WorldCacheDomain domain : domains.values()) {
            for (WorldCacheDomain.SaveKey<? extends CachedWorldData> key : domain.getKnownSaveKeys()) {
                CachedWorldData data = domain.getCachedData(worldName, key);
                if (data == null || !data.needsSaving()) continue;
                WorldCacheIOThread.scheduleSave(domain, worldName, data);
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "WorldCacheManager";
    }
}

