/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.util;

import hellfirepvp.observerlib.api.structure.MatchableStructure;
import hellfirepvp.observerlib.api.structure.Structure;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class StructureUtil {
    private StructureUtil() {
    }

    public static boolean isStructureLoaded(Structure structure, IWorld world, BlockPos offset) {
        ChunkPos min = new ChunkPos(offset.func_177971_a(structure.getMinimumOffset()));
        ChunkPos max = new ChunkPos(offset.func_177971_a(structure.getMaximumOffset()));
        for (int xx = min.field_77276_a; xx <= max.field_77276_a; ++xx) {
            for (int zz = min.field_77275_b; zz <= max.field_77275_b; ++zz) {
                if (world.func_72863_F().func_222865_a(new ChunkPos(xx, zz))) continue;
                return false;
            }
        }
        return true;
    }

    public static Optional<Integer> getLowestMismatchingSlice(MatchableStructure structure, IBlockReader world, BlockPos offset) {
        int minY = structure.getMinimumOffset().func_177956_o();
        int maxY = structure.getMaximumOffset().func_177956_o();
        for (int y = minY; y <= maxY; ++y) {
            if (structure.matchesSlice(world, offset, y)) continue;
            return Optional.of(y);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Set<BlockPos> getMismatches(MatchableStructure structure, IBlockReader world, BlockPos offset) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        structure.getContents().forEach((key, value) -> {
            if (!structure.matchesSingleBlock(world, offset, (BlockPos)key)) {
                result.add((BlockPos)key);
            }
        });
        return result;
    }
}

