/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.observerlib.api.client.StructureRenderWorld;
import hellfirepvp.observerlib.api.structure.Structure;
import hellfirepvp.observerlib.client.util.RenderTypeDecorator;
import hellfirepvp.observerlib.common.block.BlockAirRequirement;
import hellfirepvp.observerlib.common.util.RegistryUtil;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class StructureRenderer {
    private static final Random rand = new Random();
    private final StructureRenderWorld world;
    private final Structure structure;
    private double rotationX = 0.0;
    private double rotationY = 0.0;
    private double rotationZ = 0.0;
    private boolean isolateIndividualBlockRender = false;
    private boolean displayWithRequiredAir = false;

    public StructureRenderer(Structure structure) {
        this.structure = structure;
        Biome plainsBiome = (Biome)RegistryUtil.client().getValue(Registry.field_239720_u_, Biomes.field_76772_c);
        this.world = new StructureRenderWorld(this.structure, plainsBiome);
        this.resetRotation();
    }

    private void resetRotation() {
        this.rotationX = -30.0;
        this.rotationY = 45.0;
        this.rotationZ = 0.0;
    }

    public void rotate(double x, double y, double z) {
        this.rotationX += x;
        this.rotationY += y;
        this.rotationZ += z;
    }

    public void setRenderWithRequiredAir(boolean displayWithRequiredAir) {
        this.displayWithRequiredAir = displayWithRequiredAir;
    }

    public StructureRenderer setIsolateIndividualBlock(boolean isolateIndividualBlockRender) {
        this.isolateIndividualBlockRender = isolateIndividualBlockRender;
        return this;
    }

    public void rotateFromMouseDrag(float mouseDX, float mouseDZ) {
        this.rotate(0.5 * (double)(-mouseDZ), 0.5 * (double)mouseDX, 0.0);
    }

    public IWorldReader getRenderWorld() {
        return this.world;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public int getDefaultSlice() {
        return this.structure.getMinimumOffset().func_177956_o();
    }

    public boolean hasSlice(int y) {
        return y >= this.structure.getMinimumOffset().func_177956_o() && y <= this.structure.getMaximumOffset().func_177956_o();
    }

    public void render3DGUI(MatrixStack renderStack, double x, double y, float pTicks) {
        this.render3DSliceGUI(renderStack, x, y, pTicks, Optional.empty());
    }

    public void render3DSliceGUI(MatrixStack renderStack, double x, double y, float pTicks, Optional<Integer> slice) {
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen == null) {
            return;
        }
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        double scale = window.func_198100_s();
        float mul = 10.5f;
        float size = 2.0f;
        float minSize = 0.5f;
        Vector3i max = this.structure.getMaximumOffset();
        Vector3i min = this.structure.getMinimumOffset();
        float maxLength = 0.0f;
        float pointDst = max.func_177958_n() - min.func_177958_n();
        if (pointDst > maxLength) {
            maxLength = pointDst;
        }
        if ((pointDst = (float)(max.func_177956_o() - min.func_177956_o())) > maxLength) {
            maxLength = pointDst;
        }
        if ((pointDst = (float)(max.func_177952_p() - min.func_177952_p())) > maxLength) {
            maxLength = pointDst;
        }
        if ((maxLength -= 5.0f) > 0.0f) {
            size = (size - minSize) * (1.0f - maxLength / 20.0f);
        }
        float dr = -5.75f * size;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        slice.ifPresent(ySlice -> this.world.pushContentFilter(pos -> pos.func_177956_o() == ySlice.intValue()));
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(x + 16.0 / scale, y + 16.0 / scale, 512.0);
        renderStack.func_227861_a_((double)dr, (double)dr, (double)dr);
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)this.rotationX));
        renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)this.rotationY));
        renderStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)this.rotationZ));
        renderStack.func_227861_a_((double)(-dr), (double)(-dr), (double)(-dr));
        renderStack.func_227862_a_(-size * mul, -size * mul, -size * mul);
        slice.ifPresent(ySlice -> renderStack.func_227861_a_(0.0, (double)(-ySlice.intValue()), 0.0));
        BlockAirRequirement.displayRequiredAir = this.displayWithRequiredAir;
        this.structure.getContents().keySet().forEach(pos -> {
            BlockState view = this.world.func_180495_p((BlockPos)pos);
            if (!view.func_177230_c().equals(Blocks.field_150350_a)) {
                renderStack.func_227860_a_();
                renderStack.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                if (!view.func_204520_s().func_206888_e()) {
                    this.renderFluid((BlockPos)pos, view.func_204520_s(), buffers.getBuffer(this.wrapBlockRenderType(RenderType.func_228645_f_())));
                }
                RenderType type = this.wrapBlockRenderType(RenderTypeLookup.func_239221_b_((BlockState)view));
                if (this.isolateIndividualBlockRender) {
                    this.world.pushContentFilter(wPos -> wPos.equals(pos));
                    this.renderBlock((BlockPos)pos, view, buffers.getBuffer(type), renderStack);
                    this.world.popContentFilter();
                } else {
                    this.renderBlock((BlockPos)pos, view, buffers.getBuffer(type), renderStack);
                }
                renderStack.func_227865_b_();
            }
        });
        buffers.func_228461_a_();
        this.structure.getContents().keySet().forEach(pos -> {
            TileEntityRenderer tesr;
            TileEntity tile;
            if (this.isolateIndividualBlockRender) {
                this.world.pushContentFilter(wPos -> wPos.equals(pos));
            }
            if ((tile = this.world.func_175625_s((BlockPos)pos)) != null && (tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile)) != null) {
                renderStack.func_227860_a_();
                renderStack.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                tesr.func_225616_a_(tile, 0.0f, renderStack, (IRenderTypeBuffer)buffers, WorldRenderer.func_228421_a_((IBlockDisplayReader)this.world, (BlockPos)pos), OverlayTexture.field_229196_a_);
                renderStack.func_227865_b_();
            }
            if (this.isolateIndividualBlockRender) {
                this.world.popContentFilter();
            }
        });
        buffers.func_228461_a_();
        if (this.displayWithRequiredAir) {
            BlockAirRequirement.displayRequiredAir = false;
        }
        slice.ifPresent(ySlice -> this.world.popContentFilter());
        renderStack.func_227865_b_();
    }

    private RenderType wrapBlockRenderType(RenderType type) {
        return RenderTypeDecorator.wrapSetup(type, RenderSystem::disableLighting, () -> {});
    }

    private void renderFluid(BlockPos pos, FluidState fluidState, IVertexBuilder buf) {
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        brd.func_228794_a_(pos, (IBlockDisplayReader)this.world, buf, fluidState);
    }

    private void renderBlock(BlockPos offset, BlockState state, IVertexBuilder vb, MatrixStack renderStack) {
        block2: {
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            try {
                brd.renderModel(state, offset, (IBlockDisplayReader)this.world, renderStack, vb, false, rand, (IModelData)EmptyModelData.INSTANCE);
            }
            catch (Exception exc) {
                BlockRenderType type = state.func_185901_i();
                if (type != BlockRenderType.MODEL) break block2;
                IBakedModel model = brd.func_184389_a(state);
                long posRandom = state.func_209533_a(offset);
                brd.func_175019_b().renderModel((IBlockDisplayReader)this.world, model, state, offset, renderStack, vb, true, rand, posRandom, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            }
        }
    }
}

