/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.instancing;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.render.Compartment;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.BufferedModel;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.render.backend.gl.BasicProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.ProgramSpec;
import com.simibubi.create.foundation.render.backend.gl.shader.ShaderCallback;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.render.backend.instancing.ModelFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import org.apache.commons.lang3.tuple.Pair;

public class RenderMaterial<P extends BasicProgram, MODEL extends InstancedModel<?>> {
    protected final InstancedTileRenderer<?> renderer;
    protected final Map<Compartment<?>, Cache<Object, MODEL>> models;
    protected final ModelFactory<MODEL> factory;
    protected final ProgramSpec<P> programSpec;
    protected final Predicate<RenderType> layerPredicate;

    public RenderMaterial(InstancedTileRenderer<?> renderer, ProgramSpec<P> programSpec, ModelFactory<MODEL> factory) {
        this(renderer, programSpec, factory, type -> type == RenderType.func_228641_d_());
    }

    public RenderMaterial(InstancedTileRenderer<?> renderer, ProgramSpec<P> programSpec, ModelFactory<MODEL> factory, Predicate<RenderType> layerPredicate) {
        this.renderer = renderer;
        this.models = new HashMap();
        this.factory = factory;
        this.programSpec = programSpec;
        this.layerPredicate = layerPredicate;
        this.registerCompartment(Compartment.PARTIAL);
        this.registerCompartment(Compartment.DIRECTIONAL_PARTIAL);
        this.registerCompartment(Compartment.GENERIC_TILE);
    }

    public boolean canRenderInLayer(RenderType layer) {
        return this.layerPredicate.test(layer);
    }

    public void render(RenderType layer, Matrix4f projection, double camX, double camY, double camZ) {
        this.render(layer, projection, camX, camY, camZ, null);
    }

    public void render(RenderType layer, Matrix4f viewProjection, double camX, double camY, double camZ, ShaderCallback<P> setup) {
        BasicProgram program = (BasicProgram)Backend.getProgram(this.programSpec);
        program.bind(viewProjection, camX, camY, camZ, FastRenderDispatcher.getDebugMode());
        if (setup != null) {
            setup.call(program);
        }
        this.makeRenderCalls();
        this.teardown();
    }

    public void teardown() {
    }

    public void delete() {
        this.runOnAll(BufferedModel::delete);
        this.models.values().forEach(Cache::invalidateAll);
    }

    protected void makeRenderCalls() {
        for (Cache<Object, MODEL> cache : this.models.values()) {
            for (InstancedModel model : cache.asMap().values()) {
                if (model.isEmpty()) continue;
                model.render();
            }
        }
    }

    public void runOnAll(Consumer<MODEL> f) {
        for (Cache<Object, MODEL> cache : this.models.values()) {
            for (InstancedModel model : cache.asMap().values()) {
                f.accept(model);
            }
        }
    }

    public void registerCompartment(Compartment<?> instance) {
        this.models.put(instance, CacheBuilder.newBuilder().build());
    }

    public MODEL getModel(AllBlockPartials partial, BlockState referenceState) {
        return (MODEL)this.get(Compartment.PARTIAL, partial, () -> this.buildModel(partial.get(), referenceState));
    }

    public MODEL getModel(AllBlockPartials partial, BlockState referenceState, Direction dir) {
        return (MODEL)this.get(Compartment.DIRECTIONAL_PARTIAL, Pair.of((Object)dir, (Object)partial), () -> this.buildModel(partial.get(), referenceState));
    }

    public MODEL getModel(AllBlockPartials partial, BlockState referenceState, Direction dir, Supplier<MatrixStack> modelTransform) {
        return (MODEL)this.get(Compartment.DIRECTIONAL_PARTIAL, Pair.of((Object)dir, (Object)partial), () -> this.buildModel(partial.get(), referenceState, (MatrixStack)modelTransform.get()));
    }

    public MODEL getModel(BlockState toRender) {
        return (MODEL)this.get(Compartment.GENERIC_TILE, toRender, () -> this.buildModel(toRender));
    }

    public <T> MODEL get(Compartment<T> compartment, T key, Supplier<MODEL> supplier) {
        Cache<Object, MODEL> compartmentCache = this.models.get(compartment);
        try {
            return (MODEL)((InstancedModel)compartmentCache.get(key, supplier::get));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private MODEL buildModel(BlockState renderedState) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        return this.buildModel(dispatcher.func_184389_a(renderedState), renderedState);
    }

    private MODEL buildModel(IBakedModel model, BlockState renderedState) {
        return this.buildModel(model, renderedState, new MatrixStack());
    }

    private MODEL buildModel(IBakedModel model, BlockState referenceState, MatrixStack ms) {
        BufferBuilder builder = SuperByteBufferCache.getBufferBuilder(model, referenceState, ms);
        return this.factory.makeModel(this.renderer, builder);
    }
}

