/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.foundation.render.KineticRenderer;
import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.RenderWork;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class FastRenderDispatcher {
    public static WorldAttached<ConcurrentHashMap.KeySetView<TileEntity, Boolean>> queuedUpdates = new WorldAttached<ConcurrentHashMap.KeySetView>(ConcurrentHashMap::newKeySet);
    private static Matrix4f projectionMatrixThisFrame = null;

    public static void endFrame() {
        projectionMatrixThisFrame = null;
    }

    public static void enqueueUpdate(TileEntity te) {
        queuedUpdates.get((IWorld)te.func_145831_w()).add(te);
    }

    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        KineticRenderer kineticRenderer = CreateClient.kineticRenderer.get((IWorld)world);
        Entity renderViewEntity = mc.field_175622_Z;
        kineticRenderer.tick(renderViewEntity.func_226277_ct_(), renderViewEntity.func_226278_cu_(), renderViewEntity.func_226281_cx_());
        ConcurrentHashMap.KeySetView<TileEntity, Boolean> map = queuedUpdates.get((IWorld)world);
        map.forEach(te -> {
            map.remove(te);
            kineticRenderer.update(te);
        });
    }

    public static boolean available() {
        return Backend.canUseInstancing();
    }

    public static boolean available(World world) {
        return Backend.canUseInstancing() && Backend.isFlywheelWorld(world);
    }

    public static int getDebugMode() {
        return KineticDebugger.isActive() ? 1 : 0;
    }

    public static void refresh() {
        RenderWork.enqueue(() -> ((WorldRenderer)Minecraft.func_71410_x().field_71438_f).func_72712_a());
    }

    public static void renderLayer(RenderType layer, Matrix4f viewProjection, double cameraX, double cameraY, double cameraZ) {
        if (!Backend.canUseInstancing()) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        KineticRenderer kineticRenderer = CreateClient.kineticRenderer.get((IWorld)world);
        layer.func_228547_a_();
        kineticRenderer.render(layer, viewProjection, cameraX, cameraY, cameraZ);
        layer.func_228549_b_();
    }

    public static Matrix4f getProjectionMatrix() {
        float portalTime;
        if (projectionMatrixThisFrame != null) {
            return projectionMatrixThisFrame;
        }
        float partialTicks = AnimationTickHolder.getPartialTicks();
        Minecraft mc = Minecraft.func_71410_x();
        GameRenderer gameRenderer = mc.field_71460_t;
        ClientPlayerEntity player = mc.field_71439_g;
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227866_c_().func_227870_a_().func_226595_a_(gameRenderer.func_228382_a_(gameRenderer.func_215316_n(), partialTicks, true));
        gameRenderer.func_228380_a_(matrixstack, partialTicks);
        if (mc.field_71474_y.field_74336_f) {
            gameRenderer.func_228383_b_(matrixstack, partialTicks);
        }
        if ((portalTime = MathHelper.func_219799_g((float)partialTicks, (float)player.field_71080_cy, (float)player.field_71086_bY)) > 0.0f) {
            int i = 20;
            if (player.func_70644_a(Effects.field_76431_k)) {
                i = 7;
            }
            float f1 = 5.0f / (portalTime * portalTime + 5.0f) - portalTime * 0.04f;
            f1 *= f1;
            Vector3f vector3f = new Vector3f(0.0f, MathHelper.field_180189_a / 2.0f, MathHelper.field_180189_a / 2.0f);
            matrixstack.func_227863_a_(vector3f.func_229187_a_(((float)gameRenderer.field_78529_t + partialTicks) * (float)i));
            matrixstack.func_227862_a_(1.0f / f1, 1.0f, 1.0f);
            float f2 = -((float)gameRenderer.field_78529_t + partialTicks) * (float)i;
            matrixstack.func_227863_a_(vector3f.func_229187_a_(f2));
        }
        Matrix4f matrix4f = matrixstack.func_227866_c_().func_227870_a_();
        gameRenderer.func_228379_a_(matrix4f);
        projectionMatrixThisFrame = matrix4f;
        return projectionMatrixThisFrame;
    }
}

