/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend;

import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.render.backend.OptifineHandler;
import com.simibubi.create.foundation.render.backend.ShaderLoader;
import com.simibubi.create.foundation.render.backend.gl.GlFog;
import com.simibubi.create.foundation.render.backend.gl.shader.GlProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.ProgramGroup;
import com.simibubi.create.foundation.render.backend.gl.shader.ProgramSpec;
import com.simibubi.create.foundation.render.backend.gl.versioned.GlCompat;
import com.simibubi.create.foundation.render.backend.instancing.IFlywheelWorld;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;

public class Backend {
    public static final Boolean SHADER_DEBUG_OUTPUT = true;
    public static final Logger log = LogManager.getLogger(Backend.class);
    public static GLCapabilities capabilities;
    public static GlCompat compat;
    private static boolean instancingAvailable;
    private static boolean enabled;
    static final Map<ResourceLocation, ProgramSpec<?>> registry;
    static final Map<ProgramSpec<?>, ProgramGroup<?>> programs;

    public Backend() {
        throw new IllegalStateException();
    }

    public static <P extends GlProgram, S extends ProgramSpec<P>> S register(S spec) {
        ResourceLocation name = spec.name;
        if (registry.containsKey(name)) {
            throw new IllegalStateException("Program spec '" + name + "' already registered.");
        }
        registry.put(name, spec);
        return spec;
    }

    public static <P extends GlProgram, S extends ProgramSpec<P>> P getProgram(S spec) {
        return (P)programs.get(spec).get(GlFog.getFogMode());
    }

    public static boolean isFlywheelWorld(World world) {
        return world == Minecraft.func_71410_x().field_71441_e || world instanceof IFlywheelWorld && ((IFlywheelWorld)world).supportsFlywheel();
    }

    public static boolean available() {
        return Backend.canUseVBOs();
    }

    public static boolean canUseInstancing() {
        return enabled && instancingAvailable;
    }

    public static boolean canUseVBOs() {
        return enabled && Backend.gl20();
    }

    public static boolean gl33() {
        return Backend.capabilities.OpenGL33;
    }

    public static boolean gl20() {
        return Backend.capabilities.OpenGL20;
    }

    public static void init() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        IResourceManager manager = mc.func_195551_G();
        if (manager instanceof IReloadableResourceManager) {
            ISelectiveResourceReloadListener listener = ShaderLoader::onResourceManagerReload;
            ((IReloadableResourceManager)manager).func_219534_a((IFutureReloadListener)listener);
        }
    }

    public static void refresh() {
        capabilities = GL.createCapabilities();
        compat = new GlCompat(capabilities);
        instancingAvailable = compat.vertexArrayObjectsSupported() && compat.drawInstancedSupported() && compat.instancedArraysSupported();
        enabled = (Boolean)AllConfigs.CLIENT.experimentalRendering.get() != false && !OptifineHandler.usingShaders();
    }

    static {
        registry = new HashMap();
        programs = new HashMap();
    }
}

