/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Iterator;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;

public class TileEntityRenderHelper {
    public static void renderTileEntities(World world, Iterable<TileEntity> customRenderTEs, MatrixStack ms, MatrixStack localTransform, IRenderTypeBuffer buffer) {
        TileEntityRenderHelper.renderTileEntities(world, null, customRenderTEs, ms, localTransform, buffer);
    }

    public static void renderTileEntities(World world, Iterable<TileEntity> customRenderTEs, MatrixStack ms, MatrixStack localTransform, IRenderTypeBuffer buffer, float pt) {
        TileEntityRenderHelper.renderTileEntities(world, null, customRenderTEs, ms, localTransform, buffer, pt);
    }

    public static void renderTileEntities(World world, PlacementSimulationWorld renderWorld, Iterable<TileEntity> customRenderTEs, MatrixStack ms, MatrixStack localTransform, IRenderTypeBuffer buffer) {
        TileEntityRenderHelper.renderTileEntities(world, renderWorld, customRenderTEs, ms, localTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderTileEntities(World world, PlacementSimulationWorld renderWorld, Iterable<TileEntity> customRenderTEs, MatrixStack ms, MatrixStack localTransform, IRenderTypeBuffer buffer, float pt) {
        Matrix4f matrix = localTransform.func_227866_c_().func_227870_a_();
        Iterator<TileEntity> iterator = customRenderTEs.iterator();
        while (iterator.hasNext()) {
            TileEntity tileEntity = iterator.next();
            TileEntityRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            try {
                BlockPos pos = tileEntity.func_174877_v();
                ms.func_227860_a_();
                MatrixStacker.of(ms).translate((Vector3i)pos);
                Vector4f vec = new Vector4f((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 1.0f);
                vec.func_229372_a_(matrix);
                BlockPos lightPos = new BlockPos((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
                int worldLight = ContraptionRenderDispatcher.getLightOnContraption(world, renderWorld, pos, lightPos);
                renderer.func_225616_a_(tileEntity, pt, ms, buffer, worldLight, OverlayTexture.field_229196_a_);
                ms.func_227865_b_();
            }
            catch (Exception e) {
                iterator.remove();
                String message = "TileEntity " + tileEntity.func_200662_C().getRegistryName().toString() + " didn't want to render while moved.\n";
                if (((Boolean)AllConfigs.CLIENT.explainRenderErrors.get()).booleanValue()) {
                    Create.logger.error(message, (Throwable)e);
                    continue;
                }
                Create.logger.error(message);
            }
        }
    }
}

