/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class PonderButton
extends AbstractSimiWidget {
    private IScreenRenderable icon;
    private ItemStack item;
    protected boolean pressed;
    private BiConsumer<Integer, Integer> onClick;
    private int xFadeModifier;
    private int yFadeModifier;
    private float fade;
    private KeyBinding shortcut;
    private LerpedFloat flash;
    private Couple<Integer> customPassiveBorder;
    public static final int SIZE = 20;

    public PonderButton(int x, int y, BiConsumer<Integer, Integer> onClick, int width, int height) {
        super(x, y, width, height);
        this.onClick = onClick;
        this.flash = LerpedFloat.linear().startWithValue(0.0);
    }

    public PonderButton(int x, int y, BiConsumer<Integer, Integer> onClick) {
        this(x, y, onClick, 20, 20);
    }

    public PonderButton(int x, int y, Runnable onClick) {
        this(x, y, (Integer $, Integer $$) -> onClick.run());
    }

    public PonderButton showing(IScreenRenderable icon) {
        this.icon = icon;
        return this;
    }

    public PonderButton showing(ItemStack item) {
        this.item = item;
        return this;
    }

    public PonderButton customColors(int start, int end) {
        this.customPassiveBorder = Couple.create(start, end);
        return this;
    }

    public PonderButton shortcut(KeyBinding key) {
        this.shortcut = key;
        return this;
    }

    public PonderButton fade(int xModifier, int yModifier) {
        this.xFadeModifier = xModifier;
        this.yFadeModifier = yModifier;
        return this;
    }

    public void fade(float fade) {
        this.fade = fade;
    }

    public void flash() {
        float value = this.flash.getValue();
        this.flash.setValue(value + (1.0f - value) * 0.2f);
    }

    public void dim() {
        float value = this.flash.getValue();
        this.flash.setValue(value * 0.5f);
    }

    @Override
    public void func_230431_b_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int borderColorStart;
        float flashValue;
        if (!this.field_230694_p_) {
            return;
        }
        if (this.fade < 0.1f) {
            return;
        }
        this.field_230692_n_ = this.func_231047_b_(mouseX, mouseY) && this.fade > 0.75f;
        ms.func_227860_a_();
        RenderSystem.disableDepthTest();
        if (this.fade < 1.0f) {
            ms.func_227861_a_((double)((1.0f - this.fade) * -5.0f * (float)this.xFadeModifier), (double)((1.0f - this.fade) * -5.0f * (float)this.yFadeModifier), 0.0);
        }
        if ((flashValue = this.flash.getValue(partialTicks)) > 0.1f) {
            this.fade = (float)((double)this.fade * ((double)(3.0f * flashValue) + Math.sin(((float)PonderUI.ponderTicks + partialTicks) / 6.0f)));
        }
        int backgroundColor = ColorHelper.applyAlpha(-587202560, this.fade);
        int n = this.customPassiveBorder != null ? (Integer)this.customPassiveBorder.getFirst() : (borderColorStart = this.field_230692_n_ ? 0x70FFFFFF : 1084922265);
        int borderColorEnd = this.customPassiveBorder != null ? (Integer)this.customPassiveBorder.getSecond() : (this.field_230692_n_ ? 0x30FFFFFF : 548051353);
        borderColorStart = ColorHelper.applyAlpha(borderColorStart, this.fade);
        borderColorEnd = ColorHelper.applyAlpha(borderColorEnd, this.fade);
        ms.func_227861_a_(0.0, 0.0, 300.0);
        PonderUI.renderBox(ms, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, backgroundColor, borderColorStart, borderColorEnd);
        ms.func_227861_a_(0.0, 0.0, 100.0);
        if (this.icon != null) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.fade);
            ms.func_227860_a_();
            ms.func_227861_a_((double)(this.field_230690_l_ + 2), (double)(this.field_230691_m_ + 2), 0.0);
            ms.func_227862_a_((float)(this.field_230688_j_ - 4) / 16.0f, (float)(this.field_230689_k_ - 4) / 16.0f, 1.0f);
            this.icon.draw(ms, (AbstractGui)this, 0, 0);
            ms.func_227865_b_();
        }
        if (this.item != null) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, 0.0, -100.0);
            GuiGameElement.of(this.item).at(this.field_230690_l_ - 2, this.field_230691_m_ - 2).scale(1.5).render(ms);
            ms.func_227865_b_();
        }
        if (this.shortcut != null) {
            PonderButton.func_238472_a_((MatrixStack)ms, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.shortcut.func_238171_j_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2 + 8), (int)(this.field_230691_m_ + this.field_230689_k_ - 6), (int)ColorHelper.applyAlpha(-10461088, this.fade));
        }
        ms.func_227865_b_();
    }

    public void runCallback(double mouseX, double mouseY) {
        this.onClick.accept((int)mouseX, (int)mouseY);
    }

    public void func_230982_a_(double p_onClick_1_, double p_onClick_3_) {
        super.func_230982_a_(p_onClick_1_, p_onClick_3_);
        this.pressed = true;
    }

    public void func_231000_a__(double p_onRelease_1_, double p_onRelease_3_) {
        super.func_231000_a__(p_onRelease_1_, p_onRelease_3_);
        this.pressed = false;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean func_231047_b_(double x, double y) {
        double m = 4.0;
        x = Math.floor(x);
        y = Math.floor(y);
        return !(!this.field_230693_o_ || !this.field_230694_p_ || x < (double)this.field_230690_l_ - m || x > (double)(this.field_230690_l_ + this.field_230688_j_) + m - 1.0 || y < (double)this.field_230691_m_ - m || y > (double)(this.field_230691_m_ + this.field_230689_k_) + m - 1.0);
    }
}

