/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderElement;
import com.simibubi.create.foundation.ponder.PonderInstruction;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.elements.PonderOverlayElement;
import com.simibubi.create.foundation.ponder.elements.PonderSceneElement;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instructions.HideAllInstruction;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.antlr.v4.runtime.misc.IntegerList;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class PonderScene {
    public static final String TITLE_KEY = "header";
    boolean finished;
    int sceneIndex;
    int textIndex;
    String sceneId;
    IntegerList keyframeTimes;
    List<PonderInstruction> schedule;
    List<PonderInstruction> activeSchedule;
    Map<UUID, PonderElement> linkedElements;
    Set<PonderElement> elements;
    List<PonderTag> tags;
    PonderWorld world;
    ResourceLocation component;
    SceneTransform transform;
    SceneRenderInfo info;
    Outliner outliner;
    String defaultTitle;
    Vector3d pointOfInterest;
    Vector3d chasingPointOfInterest;
    WorldSectionElement baseWorldSection;
    Entity renderViewEntity;
    int basePlateOffsetX;
    int basePlateOffsetZ;
    int basePlateSize;
    float scaleFactor;
    float yOffset;
    boolean stoppedCounting;
    int totalTime;
    int currentTime;

    public PonderScene(PonderWorld world, ResourceLocation component, Collection<PonderTag> tags) {
        if (world != null) {
            world.scene = this;
        }
        this.pointOfInterest = Vector3d.field_186680_a;
        this.textIndex = 1;
        this.world = world;
        this.component = component;
        this.outliner = new Outliner();
        this.elements = new HashSet<PonderElement>();
        this.linkedElements = new HashMap<UUID, PonderElement>();
        this.tags = new ArrayList<PonderTag>(tags);
        this.schedule = new ArrayList<PonderInstruction>();
        this.activeSchedule = new ArrayList<PonderInstruction>();
        this.transform = new SceneTransform();
        this.basePlateSize = this.getBounds().func_78883_b();
        this.info = new SceneRenderInfo();
        this.baseWorldSection = new WorldSectionElement();
        this.renderViewEntity = new ArmorStandEntity((World)world, 0.0, 0.0, 0.0);
        this.keyframeTimes = new IntegerList(4);
        this.scaleFactor = 1.0f;
        this.yOffset = 0.0f;
        this.setPointOfInterest(new Vector3d(0.0, 4.0, 0.0));
    }

    public void deselect() {
        this.forEach(WorldSectionElement.class, WorldSectionElement::resetSelectedBlock);
    }

    public Pair<ItemStack, BlockPos> rayTraceScene(Vector3d from, Vector3d to) {
        MutableObject nearestHit = new MutableObject();
        MutableDouble bestDistance = new MutableDouble(0.0);
        this.forEach(WorldSectionElement.class, wse -> {
            wse.resetSelectedBlock();
            if (!wse.isVisible()) {
                return;
            }
            Pair<Vector3d, BlockPos> rayTrace = wse.rayTrace(this.world, from, to);
            if (rayTrace == null) {
                return;
            }
            double distanceTo = rayTrace.getFirst().func_72438_d(from);
            if (nearestHit.getValue() != null && distanceTo >= bestDistance.getValue()) {
                return;
            }
            nearestHit.setValue(Pair.of(wse, rayTrace.getSecond()));
            bestDistance.setValue(distanceTo);
        });
        if (nearestHit.getValue() == null) {
            return Pair.of(ItemStack.field_190927_a, null);
        }
        BlockPos selectedPos = (BlockPos)((Pair)nearestHit.getValue()).getSecond();
        BlockPos origin = new BlockPos(this.basePlateOffsetX, 0, this.basePlateOffsetZ);
        if (!this.world.getBounds().func_175898_b((Vector3i)selectedPos)) {
            return Pair.of(ItemStack.field_190927_a, null);
        }
        if (new MutableBoundingBox((Vector3i)origin, (Vector3i)origin.func_177971_a(new Vector3i(this.basePlateSize - 1, 0, this.basePlateSize - 1))).func_175898_b((Vector3i)selectedPos)) {
            return Pair.of(ItemStack.field_190927_a, selectedPos);
        }
        ((WorldSectionElement)((Pair)nearestHit.getValue()).getFirst()).selectBlock(selectedPos);
        BlockState blockState = this.world.func_180495_p(selectedPos);
        ItemStack pickBlock = blockState.getPickBlock((RayTraceResult)new BlockRayTraceResult(VecHelper.getCenterOf((Vector3i)selectedPos), Direction.UP, selectedPos, true), (IBlockReader)this.world, selectedPos, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        return Pair.of(pickBlock, selectedPos);
    }

    public String getTitle() {
        return this.getString(TITLE_KEY);
    }

    public String getString(String key) {
        return PonderLocalization.getSpecific(this.sceneId, key);
    }

    public void reset() {
        this.currentTime = 0;
        this.activeSchedule.clear();
        this.schedule.forEach((? super T mdi) -> mdi.reset(this));
    }

    public void begin() {
        this.reset();
        this.forEach(pe -> pe.reset(this));
        this.world.restore();
        this.elements.clear();
        this.linkedElements.clear();
        this.keyframeTimes.clear();
        this.transform = new SceneTransform();
        this.finished = false;
        this.setPointOfInterest(new Vector3d(0.0, 4.0, 0.0));
        this.baseWorldSection.setEmpty();
        this.baseWorldSection.forceApplyFade(1.0f);
        this.elements.add(this.baseWorldSection);
        this.totalTime = 0;
        this.stoppedCounting = false;
        this.activeSchedule.addAll(this.schedule);
        this.activeSchedule.forEach((? super T i) -> i.onScheduled(this));
    }

    public WorldSectionElement getBaseWorldSection() {
        return this.baseWorldSection;
    }

    public float getSceneProgress() {
        return this.totalTime == 0 ? 0.0f : (float)this.currentTime / (float)this.totalTime;
    }

    public void fadeOut() {
        this.reset();
        this.activeSchedule.add(new HideAllInstruction(10, null));
    }

    public void renderScene(SuperRenderTypeBuffer buffer, MatrixStack ms, float pt) {
        ms.func_227860_a_();
        Minecraft mc = Minecraft.func_71410_x();
        Entity prevRVE = mc.field_175622_Z;
        mc.field_175622_Z = this.renderViewEntity;
        this.forEachVisible(PonderSceneElement.class, e -> e.renderFirst(this.world, buffer, ms, pt));
        mc.field_175622_Z = prevRVE;
        for (RenderType type : RenderType.func_228661_n_()) {
            this.forEachVisible(PonderSceneElement.class, e -> e.renderLayer(this.world, buffer, type, ms, pt));
        }
        this.forEachVisible(PonderSceneElement.class, e -> e.renderLast(this.world, buffer, ms, pt));
        this.info.set(this.transform.xRotation.getValue(pt), this.transform.yRotation.getValue(pt));
        this.world.renderEntities(ms, buffer, this.info, pt);
        this.world.renderParticles(ms, buffer, this.info, pt);
        this.outliner.renderOutlines(ms, buffer, pt);
        ms.func_227865_b_();
    }

    public void renderOverlay(PonderUI screen, MatrixStack ms, float partialTicks) {
        ms.func_227860_a_();
        this.forEachVisible(PonderOverlayElement.class, e -> e.render(this, screen, ms, partialTicks));
        ms.func_227865_b_();
    }

    public void setPointOfInterest(Vector3d poi) {
        if (this.chasingPointOfInterest == null) {
            this.pointOfInterest = poi;
        }
        this.chasingPointOfInterest = poi;
    }

    public Vector3d getPointOfInterest() {
        return this.pointOfInterest;
    }

    public void tick() {
        if (this.chasingPointOfInterest != null) {
            this.pointOfInterest = VecHelper.lerp(0.25f, this.pointOfInterest, this.chasingPointOfInterest);
        }
        this.outliner.tickOutlines();
        this.world.tick();
        this.transform.tick();
        this.forEach(e -> e.tick(this));
        if (this.currentTime < this.totalTime) {
            ++this.currentTime;
        }
        Iterator<PonderInstruction> iterator = this.activeSchedule.iterator();
        while (iterator.hasNext()) {
            PonderInstruction instruction = iterator.next();
            instruction.tick(this);
            if (instruction.isComplete()) {
                iterator.remove();
                if (!instruction.isBlocking()) continue;
                break;
            }
            if (!instruction.isBlocking()) continue;
            break;
        }
        if (this.activeSchedule.isEmpty()) {
            this.finished = true;
        }
    }

    public void seekToTime(int time) {
        if (time < this.currentTime) {
            throw new IllegalStateException("Cannot seek backwards. Rewind first.");
        }
        while (this.currentTime < time && !this.finished) {
            this.forEach(e -> e.whileSkipping(this));
            this.tick();
        }
        this.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
    }

    public void addToSceneTime(int time) {
        if (!this.stoppedCounting) {
            this.totalTime += time;
        }
    }

    public void stopCounting() {
        this.stoppedCounting = true;
    }

    public void markKeyframe(int offset) {
        if (!this.stoppedCounting) {
            this.keyframeTimes.add(this.totalTime + offset);
        }
    }

    public void addElement(PonderElement e) {
        this.elements.add(e);
    }

    public <E extends PonderElement> void linkElement(E e, ElementLink<E> link) {
        this.linkedElements.put(link.getId(), e);
    }

    public <E extends PonderElement> E resolve(ElementLink<E> link) {
        return link.cast(this.linkedElements.get(link.getId()));
    }

    public <E extends PonderElement> void runWith(ElementLink<E> link, Consumer<E> callback) {
        callback.accept(this.resolve(link));
    }

    public <E extends PonderElement, F> F applyTo(ElementLink<E> link, Function<E, F> function) {
        return function.apply(this.resolve(link));
    }

    public PonderWorld getWorld() {
        return this.world;
    }

    public Set<PonderElement> getElements() {
        return this.elements;
    }

    public void forEach(Consumer<? super PonderElement> function) {
        for (PonderElement elemtent : this.elements) {
            function.accept(elemtent);
        }
    }

    public <T extends Entity> void forEachWorldEntity(Class<T> type, Consumer<T> function) {
        this.world.getEntities().filter(type::isInstance).map(type::cast).forEach(function);
    }

    public <T extends PonderElement> void forEach(Class<T> type, Consumer<T> function) {
        for (PonderElement element : this.elements) {
            if (!type.isInstance(element)) continue;
            function.accept(type.cast(element));
        }
    }

    public <T extends PonderElement> void forEachVisible(Class<T> type, Consumer<T> function) {
        for (PonderElement element : this.elements) {
            if (!type.isInstance(element) || !element.isVisible()) continue;
            function.accept(type.cast(element));
        }
    }

    public MutableBoundingBox getBounds() {
        return this.world == null ? new MutableBoundingBox() : this.world.getBounds();
    }

    public Supplier<String> registerText(String defaultText) {
        String key = "text_" + this.textIndex;
        PonderLocalization.registerSpecific(this.sceneId, key, defaultText);
        Supplier<String> supplier = () -> PonderLocalization.getSpecific(this.sceneId, key);
        ++this.textIndex;
        return supplier;
    }

    public SceneBuilder builder() {
        return new SceneBuilder(this);
    }

    public SceneBuildingUtil getSceneBuildingUtil() {
        return new SceneBuildingUtil(this.getBounds());
    }

    public SceneTransform getTransform() {
        return this.transform;
    }

    public Outliner getOutliner() {
        return this.outliner;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public class SceneRenderInfo
    extends ActiveRenderInfo {
        public void set(float xRotation, float yRotation) {
            this.func_216776_a(yRotation, xRotation);
        }
    }

    public class SceneTransform {
        public LerpedFloat xRotation = LerpedFloat.angular().startWithValue(-35.0);
        public LerpedFloat yRotation = LerpedFloat.angular().startWithValue(145.0);
        int width;
        int height;
        double offset;
        Matrix4f cachedMat;

        public void tick() {
            this.xRotation.tickChaser();
            this.yRotation.tickChaser();
        }

        public void updateScreenParams(int width, int height, double offset) {
            this.width = width;
            this.height = height;
            this.offset = offset;
            this.cachedMat = null;
        }

        public MatrixStack apply(MatrixStack ms) {
            return this.apply(ms, AnimationTickHolder.getPartialTicks((IWorld)PonderScene.this.world), false);
        }

        public MatrixStack apply(MatrixStack ms, float pt, boolean overlayCompatible) {
            ms.func_227861_a_((double)(this.width / 2), (double)(this.height / 2), 200.0 + this.offset);
            MatrixStacker.of(ms).rotateX(-35.0).rotateY(55.0);
            ms.func_227861_a_(this.offset, 0.0, 0.0);
            MatrixStacker.of(ms).rotateY(-55.0).rotateX(35.0);
            MatrixStacker.of(ms).rotateX(this.xRotation.getValue(pt)).rotateY(this.yRotation.getValue(pt));
            float f = 30.0f * PonderScene.this.scaleFactor;
            if (!overlayCompatible) {
                ms.func_227862_a_(f, -f, f);
                ms.func_227861_a_((double)((float)(PonderScene.this.basePlateSize + PonderScene.this.basePlateOffsetX) / -2.0f), (double)(-1.0f + PonderScene.this.yOffset), (double)((float)(PonderScene.this.basePlateSize + PonderScene.this.basePlateOffsetZ) / -2.0f));
            } else {
                ms.func_227862_a_(f, f, f);
                ms.func_227861_a_((double)((float)(PonderScene.this.basePlateSize + PonderScene.this.basePlateOffsetX) / -2.0f), (double)(-PonderScene.this.yOffset), (double)((float)(PonderScene.this.basePlateSize + PonderScene.this.basePlateOffsetZ) / -2.0f));
                float y = (float)(0.5065 * Math.pow(2.2975, Math.log(1.0f / PonderScene.this.scaleFactor) / Math.log(2.0))) / 30.0f;
                ms.func_227862_a_(y, -y, -y);
            }
            return ms;
        }

        public void updateSceneRVE(float pt) {
            Vector3d v = this.screenToScene(this.width / 2, this.height / 2, 500, pt);
            PonderScene.this.renderViewEntity.func_70107_b(v.field_72450_a, v.field_72448_b, v.field_72449_c);
        }

        public Vector3d screenToScene(double x, double y, int depth, float pt) {
            this.refreshMatrix(pt);
            Vector3d vec = new Vector3d(x, y, (double)depth);
            vec = vec.func_178786_a((double)(this.width / 2), (double)(this.height / 2), 200.0 + this.offset);
            vec = VecHelper.rotate(vec, 35.0, Direction.Axis.X);
            vec = VecHelper.rotate(vec, -55.0, Direction.Axis.Y);
            vec = vec.func_178786_a(this.offset, 0.0, 0.0);
            vec = VecHelper.rotate(vec, 55.0, Direction.Axis.Y);
            vec = VecHelper.rotate(vec, -35.0, Direction.Axis.X);
            vec = VecHelper.rotate(vec, -this.xRotation.getValue(pt), Direction.Axis.X);
            vec = VecHelper.rotate(vec, -this.yRotation.getValue(pt), Direction.Axis.Y);
            float f = 1.0f / (30.0f * PonderScene.this.scaleFactor);
            vec = vec.func_216372_d((double)f, (double)(-f), (double)f);
            vec = vec.func_178786_a((double)((float)(PonderScene.this.basePlateSize + PonderScene.this.basePlateOffsetX) / -2.0f), (double)(-1.0f + PonderScene.this.yOffset), (double)((float)(PonderScene.this.basePlateSize + PonderScene.this.basePlateOffsetZ) / -2.0f));
            return vec;
        }

        public Vector2f sceneToScreen(Vector3d vec, float pt) {
            this.refreshMatrix(pt);
            Vector4f vec4 = new Vector4f((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c, 1.0f);
            vec4.func_229372_a_(this.cachedMat);
            return new Vector2f(vec4.func_195910_a(), vec4.func_195913_b());
        }

        protected void refreshMatrix(float pt) {
            if (this.cachedMat != null) {
                return;
            }
            this.cachedMat = this.apply(new MatrixStack(), pt, false).func_227866_c_().func_227870_a_();
        }
    }
}

