/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.gson.JsonElement;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.content.PonderChapterRegistry;
import com.simibubi.create.foundation.ponder.content.PonderIndex;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.content.PonderTagRegistry;
import com.simibubi.create.foundation.ponder.content.SharedText;
import com.simibubi.create.repack.registrate.util.entry.ItemProviderEntry;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class PonderRegistry {
    public static final PonderTagRegistry tags = new PonderTagRegistry();
    public static final PonderChapterRegistry chapters = new PonderChapterRegistry();
    public static Map<ResourceLocation, List<PonderStoryBoardEntry>> all = new HashMap<ResourceLocation, List<PonderStoryBoardEntry>>();

    public static PonderSceneBuilder addStoryBoard(ItemProviderEntry<?> component, String schematic, PonderStoryBoardEntry.PonderStoryBoard storyBoard, PonderTag ... tags) {
        ResourceLocation id = component.getId();
        PonderStoryBoardEntry entry = new PonderStoryBoardEntry(storyBoard, schematic, id);
        PonderSceneBuilder builder = new PonderSceneBuilder(entry);
        if (tags.length > 0) {
            builder.highlightTags(tags);
        }
        all.computeIfAbsent(id, _$ -> new ArrayList()).add(entry);
        return builder;
    }

    public static PonderSceneBuilder addStoryBoard(PonderChapter chapter, ResourceLocation component, String schematic, PonderStoryBoardEntry.PonderStoryBoard storyBoard) {
        if (component == null) {
            component = new ResourceLocation("minecraft", "stick");
        }
        PonderStoryBoardEntry entry = new PonderStoryBoardEntry(storyBoard, schematic, component);
        PonderSceneBuilder builder = new PonderSceneBuilder(entry);
        chapters.addStoriesToChapter(chapter, entry);
        return builder;
    }

    public static MultiSceneBuilder forComponents(ItemProviderEntry<?> ... components) {
        return new MultiSceneBuilder(Arrays.asList(components));
    }

    public static List<PonderScene> compile(ResourceLocation id) {
        return PonderRegistry.compile(all.get(id));
    }

    public static List<PonderScene> compile(PonderChapter chapter) {
        return PonderRegistry.compile(chapters.getStories(chapter));
    }

    public static List<PonderScene> compile(List<PonderStoryBoardEntry> entries) {
        ArrayList<PonderScene> scenes = new ArrayList<PonderScene>();
        for (int i = 0; i < entries.size(); ++i) {
            PonderStoryBoardEntry sb = entries.get(i);
            Template activeTemplate = PonderRegistry.loadSchematic(sb.getSchematicName());
            PonderWorld world = new PonderWorld(BlockPos.field_177992_a, (World)Minecraft.func_71410_x().field_71441_e);
            activeTemplate.func_237152_b_((IServerWorld)world, BlockPos.field_177992_a, new PlacementSettings(), world.field_73012_v);
            world.createBackup();
            PonderScene scene = PonderRegistry.compileScene(i, sb, world);
            scene.begin();
            scenes.add(scene);
        }
        return scenes;
    }

    public static PonderScene compileScene(int i, PonderStoryBoardEntry sb, PonderWorld world) {
        PonderScene scene = new PonderScene(world, sb.getComponent(), sb.getTags());
        SceneBuilder builder = scene.builder();
        sb.getBoard().program(builder, scene.getSceneBuildingUtil());
        return scene;
    }

    public static Template loadSchematic(String path) {
        Template t = new Template();
        String filepath = "ponder/" + path + ".nbt";
        InputStream resourceAsStream = Create.class.getClassLoader().getResourceAsStream(filepath);
        if (resourceAsStream == null) {
            Create.logger.error("Ponder schematic missing: " + path);
            return t;
        }
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceAsStream)));){
            CompoundNBT nbt = CompressedStreamTools.func_152456_a((DataInput)stream, (NBTSizeTracker)new NBTSizeTracker(0x20000000L));
            t.func_186256_b(nbt);
        }
        catch (IOException e) {
            Create.logger.warn("Failed to read ponder schematic", (Throwable)e);
        }
        return t;
    }

    public static JsonElement provideLangEntries() {
        PonderIndex.register();
        PonderTag.register();
        SharedText.gatherText();
        all.forEach((id, list) -> {
            for (int i = 0; i < list.size(); ++i) {
                PonderRegistry.compileScene(i, (PonderStoryBoardEntry)list.get(i), null);
            }
        });
        return PonderLocalization.record();
    }

    public static class PonderSceneBuilder {
        private final PonderStoryBoardEntry entry;

        PonderSceneBuilder(PonderStoryBoardEntry entry) {
            this.entry = entry;
        }

        public PonderSceneBuilder highlightAllTags() {
            this.entry.getTags().add(PonderTag.Highlight.ALL);
            return this;
        }

        public PonderSceneBuilder highlightTags(PonderTag ... tags) {
            this.entry.getTags().addAll(Arrays.asList(tags));
            return this;
        }

        public PonderSceneBuilder chapter(PonderChapter chapter) {
            chapters.addStoriesToChapter(chapter, this.entry);
            return this;
        }

        public PonderSceneBuilder chapters(PonderChapter ... chapters) {
            for (PonderChapter c : chapters) {
                this.chapter(c);
            }
            return this;
        }
    }

    public static class MultiSceneBuilder {
        private final Collection<ItemProviderEntry<?>> components;

        MultiSceneBuilder(Collection<ItemProviderEntry<?>> components) {
            this.components = components;
        }

        public MultiSceneBuilder addStoryBoard(String schematicPath, PonderStoryBoardEntry.PonderStoryBoard storyBoard) {
            return this.addStoryBoard(schematicPath, storyBoard, (PonderSceneBuilder $) -> {});
        }

        public MultiSceneBuilder addStoryBoard(String schematicPath, PonderStoryBoardEntry.PonderStoryBoard storyBoard, PonderTag ... tags) {
            return this.addStoryBoard(schematicPath, storyBoard, (PonderSceneBuilder sb) -> sb.highlightTags(tags));
        }

        public MultiSceneBuilder addStoryBoard(String schematicPath, PonderStoryBoardEntry.PonderStoryBoard storyBoard, Consumer<PonderSceneBuilder> extras) {
            this.components.forEach(c -> extras.accept(PonderRegistry.addStoryBoard(c, schematicPath, storyBoard, new PonderTag[0])));
            return this;
        }
    }
}

