/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config;

import com.simibubi.create.foundation.config.CClient;
import com.simibubi.create.foundation.config.CCommon;
import com.simibubi.create.foundation.config.CServer;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class AllConfigs {
    static Map<ConfigBase, ModConfig.Type> configs = new HashMap<ConfigBase, ModConfig.Type>();
    public static CClient CLIENT;
    public static CCommon COMMON;
    public static CServer SERVER;

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        configs.put(config, side);
        return (T)config;
    }

    public static void register() {
        CLIENT = AllConfigs.register(CClient::new, ModConfig.Type.CLIENT);
        COMMON = AllConfigs.register(CCommon::new, ModConfig.Type.COMMON);
        SERVER = AllConfigs.register(CServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ConfigBase, ModConfig.Type> pair : configs.entrySet()) {
            ModLoadingContext.get().registerConfig(pair.getValue(), pair.getKey().specification);
        }
    }

    public static void onLoad(ModConfig.Loading event) {
        for (Map.Entry<ConfigBase, ModConfig.Type> pair : configs.entrySet()) {
            if (pair.getKey().specification != event.getConfig().getSpec()) continue;
            pair.getKey().onLoad();
        }
    }

    public static void onReload(ModConfig.Reloading event) {
        for (Map.Entry<ConfigBase, ModConfig.Type> pair : configs.entrySet()) {
            if (pair.getKey().specification != event.getConfig().getSpec()) continue;
            pair.getKey().onReload();
        }
    }
}

