/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.filtering;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class SchematicInstances {
    public static WorldAttached<Cache<Integer, SchematicWorld>> loadedSchematics = new WorldAttached<Cache>(() -> CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());

    public static void register() {
    }

    @Nullable
    public static SchematicWorld get(World world, ItemStack schematic) {
        Cache<Integer, SchematicWorld> map = loadedSchematics.get((IWorld)world);
        int hash = SchematicInstances.getHash(schematic);
        try {
            return (SchematicWorld)((Object)map.get((Object)hash, () -> SchematicInstances.loadWorld(world, schematic)));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SchematicWorld loadWorld(World wrapped, ItemStack schematic) {
        if (schematic == null || !schematic.func_77942_o()) {
            return null;
        }
        if (!schematic.func_77978_p().func_74767_n("Deployed")) {
            return null;
        }
        Template activeTemplate = SchematicItem.loadSchematic(schematic);
        if (activeTemplate.func_186259_a().equals((Object)BlockPos.field_177992_a)) {
            return null;
        }
        BlockPos anchor = NBTUtil.func_186861_c((CompoundNBT)schematic.func_77978_p().func_74775_l("Anchor"));
        SchematicWorld world = new SchematicWorld(anchor, wrapped);
        PlacementSettings settings = SchematicItem.getSettings(schematic);
        activeTemplate.func_237144_a_((IServerWorld)world, anchor, settings, wrapped.func_201674_k());
        return world;
    }

    public static void clearHash(ItemStack schematic) {
        if (schematic == null || !schematic.func_77942_o()) {
            return;
        }
        schematic.func_77978_p().func_82580_o("SchematicHash");
    }

    public static int getHash(ItemStack schematic) {
        if (schematic == null || !schematic.func_77942_o()) {
            return -1;
        }
        CompoundNBT tag = schematic.func_77978_p();
        if (!tag.func_74764_b("SchematicHash")) {
            tag.func_74768_a("SchematicHash", tag.toString().hashCode());
        }
        return tag.func_74762_e("SchematicHash");
    }
}

