/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.logistics.block.redstone.ContentObserverBlock;
import com.simibubi.create.content.logistics.block.redstone.FilteredDetectorFilterSlot;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class ContentObserverTileEntity
extends SmartTileEntity {
    private static final int DEFAULT_DELAY = 6;
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    public int turnOffTicks = 0;

    public ContentObserverTileEntity(TileEntityType<? extends ContentObserverTileEntity> type) {
        super(type);
        this.setLazyTickRate(20);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FilteredDetectorFilterSlot()).moveText(new Vector3d(0.0, 5.0, 0.0));
        behaviours.add(this.filtering);
        this.observedInventory = new InvManipulationBehaviour(this, InvManipulationBehaviour.InterfaceProvider.towardBlockFacing()).bypassSidedness();
        behaviours.add(this.observedInventory);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        BlockState state = this.func_195044_w();
        if (this.turnOffTicks > 0) {
            --this.turnOffTicks;
            if (this.turnOffTicks == 0) {
                this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)state.func_177230_c(), 1);
            }
        }
        if (!this.isActive()) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)ContentObserverBlock.field_185512_D);
        BlockPos targetPos = this.field_174879_c.func_177972_a(facing);
        TransportedItemStackHandlerBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, targetPos, TransportedItemStackHandlerBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.handleCenteredProcessingOnAllItems(0.45f, stack -> {
                if (!this.filtering.test(stack.stack) || this.turnOffTicks == 6) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                this.activate();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
            return;
        }
        if (!this.observedInventory.simulate().extract().func_190926_b()) {
            this.activate();
            return;
        }
    }

    public void activate() {
        this.activate(6);
    }

    public void activate(int ticks) {
        BlockState state = this.func_195044_w();
        this.turnOffTicks = ticks;
        if (((Boolean)state.func_177229_b((Property)ContentObserverBlock.POWERED)).booleanValue()) {
            return;
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ContentObserverBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.field_145850_b.func_195593_d(this.field_174879_c, state.func_177230_c());
    }

    private boolean isActive() {
        return true;
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74768_a("TurnOff", this.turnOffTicks);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.turnOffTicks = compound.func_74762_e("TurnOff");
    }
}

