/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.logistics.block.depot.EjectorTileEntity;
import com.simibubi.create.content.logistics.block.depot.EjectorTriggerPacket;
import com.simibubi.create.content.logistics.block.depot.SharedDepotBlockMethods;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EjectorBlock
extends HorizontalKineticBlock
implements ITE<EjectorTileEntity> {
    public EjectorBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.DEPOT;
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.getTileEntityOptional((IBlockReader)world, pos).filter(ete -> ete.state == EjectorTileEntity.State.LAUNCHING).map($ -> Float.valueOf(1.0f)).orElse(Float.valueOf(super.getSlipperiness(state, world, pos, entity))).floatValue();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        this.withTileEntityDo((IBlockReader)world, pos, EjectorTileEntity::updateSignal);
    }

    public void func_180658_a(World p_180658_1_, BlockPos p_180658_2_, Entity p_180658_3_, float p_180658_4_) {
        Optional tileEntityOptional = this.getTileEntityOptional((IBlockReader)p_180658_1_, p_180658_2_);
        if (tileEntityOptional.isPresent() && !p_180658_3_.func_226272_bl_()) {
            p_180658_3_.func_225503_b_(p_180658_4_, 0.0f);
            return;
        }
        super.func_180658_a(p_180658_1_, p_180658_2_, p_180658_3_, p_180658_4_);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        BlockPos position = entityIn.func_233580_cy_();
        if (!AllBlocks.WEIGHTED_EJECTOR.has(worldIn.func_180495_p(position))) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        if (entityIn.func_226272_bl_()) {
            return;
        }
        if (entityIn instanceof ItemEntity) {
            SharedDepotBlockMethods.onLanded(worldIn, entityIn);
            return;
        }
        Optional teProvider = this.getTileEntityOptional(worldIn, position);
        if (!teProvider.isPresent()) {
            return;
        }
        EjectorTileEntity ejectorTileEntity = (EjectorTileEntity)teProvider.get();
        if (ejectorTileEntity.getState() == EjectorTileEntity.State.RETRACTING) {
            return;
        }
        if (ejectorTileEntity.powered) {
            return;
        }
        if (ejectorTileEntity.launcher.getHorizontalDistance() == 0) {
            return;
        }
        if (entityIn.field_70122_E) {
            entityIn.field_70122_E = false;
            Vector3d center = VecHelper.getCenterOf((Vector3i)position).func_72441_c(0.0, 0.4375, 0.0);
            Vector3d positionVec = entityIn.func_213303_ch();
            double diff = center.func_72438_d(positionVec);
            entityIn.func_213293_j(0.0, -0.125, 0.0);
            Vector3d vec = center.func_178787_e(positionVec).func_186678_a(0.5);
            if (diff > 0.25) {
                entityIn.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                return;
            }
        }
        ejectorTileEntity.activate();
        ejectorTileEntity.notifyUpdate();
        if (entityIn.field_70170_p.field_72995_K) {
            AllPackets.channel.sendToServer((Object)new EjectorTriggerPacket(ejectorTileEntity.func_174877_v()));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (AllItems.WRENCH.isIn(player.func_184586_b(hand))) {
            return ActionResultType.PASS;
        }
        return SharedDepotBlockMethods.onUse(state, world, pos, player, hand, ray);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.withTileEntityDo((IBlockReader)worldIn, pos, EjectorTileEntity::dropFlyingItems);
        SharedDepotBlockMethods.onReplaced(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176746_e().func_176740_k();
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return this.getRotationAxis(state) == face.func_176740_k();
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.WEIGHTED_EJECTOR.create();
    }

    @Override
    public Class<EjectorTileEntity> getTileEntityClass() {
        return EjectorTileEntity.class;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return SharedDepotBlockMethods.getComparatorInputOverride(blockState, worldIn, pos);
    }
}

