/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ZapperRenderHandler {
    public static List<LaserBeam> cachedBeams;
    public static float leftHandAnimation;
    public static float rightHandAnimation;
    public static float lastLeftHandAnimation;
    public static float lastRightHandAnimation;
    private static boolean dontReequipLeft;
    private static boolean dontReequipRight;

    public static Vector3d getExactBarrelPos(boolean mainHand) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float yaw = (float)((double)(player.func_195046_g(partialTicks) / -180.0f) * Math.PI);
        float pitch = (float)((double)(player.func_195050_f(partialTicks) / -180.0f) * Math.PI);
        boolean rightHand = mainHand == (player.func_184591_cq() == HandSide.RIGHT);
        float zOffset = ((float)Minecraft.func_71410_x().field_71474_y.field_74334_X - 70.0f) / -100.0f;
        Vector3d barrelPosNoTransform = new Vector3d(rightHand ? (double)-0.35f : (double)0.35f, (double)-0.115f, (double)(0.75f + zOffset));
        Vector3d barrelPos = player.func_174824_e(partialTicks).func_178787_e(barrelPosNoTransform.func_178789_a(pitch).func_178785_b(yaw));
        return barrelPos;
    }

    public static void tick() {
        lastLeftHandAnimation = leftHandAnimation;
        lastRightHandAnimation = rightHandAnimation;
        leftHandAnimation *= 0.8f;
        rightHandAnimation *= 0.8f;
        if (cachedBeams == null) {
            cachedBeams = new LinkedList<LaserBeam>();
        }
        cachedBeams.removeIf(b -> b.itensity < 0.1f);
        if (cachedBeams.isEmpty()) {
            return;
        }
        cachedBeams.forEach(beam -> CreateClient.outliner.endChasingLine(beam, beam.start, beam.end, 1.0f - beam.itensity).disableNormals().colored(0xFFFFFF).lineWidth(beam.itensity * 1.0f / 8.0f));
        cachedBeams.forEach(b -> b.itensity *= 0.6f);
    }

    public static void shoot(Hand hand) {
        ClientPlayerEntity player;
        boolean rightHand = hand == Hand.MAIN_HAND ^ (player = Minecraft.func_71410_x().field_71439_g).func_184591_cq() == HandSide.LEFT;
        if (rightHand) {
            rightHandAnimation = 0.2f;
            dontReequipRight = false;
        } else {
            leftHandAnimation = 0.2f;
            dontReequipLeft = false;
        }
        ZapperRenderHandler.playSound(hand, player.func_233580_cy_());
    }

    public static void playSound(Hand hand, BlockPos position) {
        float pitch = hand == Hand.MAIN_HAND ? 2.0f : 0.9f;
        Minecraft.func_71410_x().field_71441_e.func_184156_a(position, AllSoundEvents.BLOCKZAPPER_PLACE.get(), SoundCategory.BLOCKS, 0.8f, pitch, false);
    }

    public static void addBeam(LaserBeam beam) {
        Random r = new Random();
        double x = beam.end.field_72450_a;
        double y = beam.end.field_72448_b;
        double z = beam.end.field_72449_c;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Supplier<Double> randomSpeed = () -> (r.nextDouble() - 0.5) * (double)0.2f;
        Supplier<Double> randomOffset = () -> (r.nextDouble() - 0.5) * (double)0.2f;
        for (int i = 0; i < 10; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue());
            world.func_195594_a((IParticleData)ParticleTypes.field_197629_v, x + randomOffset.get(), y + randomOffset.get(), z + randomOffset.get(), 0.0, 0.0, 0.0);
        }
        cachedBeams.add(beam);
    }

    @SubscribeEvent
    public static void onRenderPlayerHand(RenderHandEvent event) {
        ItemStack heldItem = event.getItemStack();
        if (!(heldItem.func_77973_b() instanceof ZapperItem)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean rightHand = event.getHand() == Hand.MAIN_HAND ^ mc.field_71439_g.func_184591_cq() == HandSide.LEFT;
        MatrixStack ms = event.getMatrixStack();
        ms.func_227860_a_();
        float recoil = rightHand ? MathHelper.func_219799_g((float)event.getPartialTicks(), (float)lastRightHandAnimation, (float)rightHandAnimation) : MathHelper.func_219799_g((float)event.getPartialTicks(), (float)lastLeftHandAnimation, (float)leftHandAnimation);
        float equipProgress = event.getEquipProgress();
        if (rightHand && (rightHandAnimation > 0.01f || dontReequipRight)) {
            equipProgress = 0.0f;
        }
        if (!rightHand && (leftHandAnimation > 0.01f || dontReequipLeft)) {
            equipProgress = 0.0f;
        }
        float f = rightHand ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)event.getSwingProgress());
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(event.getSwingProgress() * (float)Math.PI));
        float f5 = MathHelper.func_76126_a((float)(event.getSwingProgress() * event.getSwingProgress() * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        ms.func_227861_a_((double)(f * (f2 + 0.64000005f - 0.1f)), (double)(f3 + -0.4f + equipProgress * -0.6f), (double)(f4 + -0.71999997f + 0.3f + recoil));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * 75.0f));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * f6 * 70.0f));
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * f5 * -20.0f));
        ClientPlayerEntity abstractclientplayerentity = mc.field_71439_g;
        mc.func_110434_K().func_110577_a(abstractclientplayerentity.func_110306_p());
        ms.func_227861_a_((double)(f * -1.0f), (double)3.6f, 3.5);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * 120.0f));
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(200.0f));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * -135.0f));
        ms.func_227861_a_((double)(f * 5.6f), 0.0, 0.0);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * 40.0f));
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.func_175598_ae().func_78713_a((Entity)abstractclientplayerentity);
        if (rightHand) {
            playerrenderer.func_229144_a_(event.getMatrixStack(), event.getBuffers(), event.getLight(), (AbstractClientPlayerEntity)abstractclientplayerentity);
        } else {
            playerrenderer.func_229146_b_(event.getMatrixStack(), event.getBuffers(), event.getLight(), (AbstractClientPlayerEntity)abstractclientplayerentity);
        }
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227861_a_((double)(f * (f2 + 0.64000005f - 0.1f)), (double)(f3 + -0.4f + equipProgress * -0.6f), (double)(f4 + -0.71999997f - 0.1f + recoil));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * f6 * 70.0f));
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * f5 * -20.0f));
        ms.func_227861_a_((double)(f * -0.1f), (double)0.1f, (double)-0.4f);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * 5.0f));
        FirstPersonRenderer firstPersonRenderer = mc.func_175597_ag();
        firstPersonRenderer.func_228397_a_((LivingEntity)mc.field_71439_g, heldItem, rightHand ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !rightHand, event.getMatrixStack(), event.getBuffers(), event.getLight());
        ms.func_227865_b_();
        event.setCanceled(true);
    }

    public static void dontAnimateItem(Hand hand) {
        boolean rightHand = hand == Hand.MAIN_HAND ^ Minecraft.func_71410_x().field_71439_g.func_184591_cq() == HandSide.LEFT;
        dontReequipRight |= rightHand;
        dontReequipLeft |= !rightHand;
    }

    public static class LaserBeam {
        float itensity;
        Vector3d start;
        Vector3d end;
        boolean follow;
        boolean mainHand;

        public LaserBeam(Vector3d start, Vector3d end) {
            this.start = start;
            this.end = end;
            this.itensity = 1.0f;
        }

        public LaserBeam followPlayer(boolean follow, boolean mainHand) {
            this.follow = follow;
            this.mainHand = mainHand;
            return this;
        }
    }
}

