/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.outliner.Outline;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GoggleOverlayRenderer {
    private static final Map<Object, Outliner.OutlineEntry> outlines = CreateClient.outliner.getOutlines();

    @SubscribeEvent
    public static void lookingAtBlocksThroughGogglesShowsTooltip(RenderGameOverlayEvent.Post event) {
        boolean exceptionAdded;
        MatrixStack ms = event.getMatrixStack();
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return;
        }
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        BlockPos pos = result.func_216350_a();
        ItemStack headSlot = mc.field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
        TileEntity te = world.func_175625_s(pos);
        boolean wearingGoggles = AllItems.GOGGLES.isIn(headSlot);
        boolean hasGoggleInformation = te instanceof IHaveGoggleInformation;
        boolean hasHoveringInformation = te instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)te;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, mc.field_71439_g.func_225608_bj_());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(StringTextComponent.field_240750_d_);
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)te;
            hoverAddedInformation = hte.addToTooltip(tooltip, mc.field_71439_g.func_225608_bj_());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (te instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)te).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (wearingGoggles && AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            Direction[] directions = Iterate.directionsInAxis(((Direction)state.func_177229_b((Property)PistonExtensionPoleBlock.field_176387_N)).func_176740_k());
            int poles = 1;
            boolean pistonFound = false;
            for (Direction dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles((World)world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.func_180495_p(pos.func_177967_a(dir, attachedPoles + 1)).func_177230_c() instanceof MechanicalPistonBlock;
            }
            if (!pistonFound) {
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(StringTextComponent.field_240750_d_);
            }
            tooltip.add((ITextComponent)IHaveGoggleInformation.componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("gui.goggles.pole_length", new Object[0])).func_230529_a_((ITextComponent)new StringTextComponent(" " + poles)));
        }
        if (tooltip.isEmpty()) {
            return;
        }
        ms.func_227860_a_();
        TooltipScreen tooltipScreen = new TooltipScreen(null);
        tooltipScreen.func_231158_b_(mc, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p());
        int posX = tooltipScreen.field_230708_k_ / 2 + (Integer)AllConfigs.CLIENT.overlayOffsetX.get();
        int posY = tooltipScreen.field_230709_l_ / 2 + (Integer)AllConfigs.CLIENT.overlayOffsetY.get();
        tooltipScreen.func_243308_b(ms, tooltip, posX, posY);
        ItemStack item = AllItems.GOGGLES.asStack();
        GuiGameElement.of(item).at(posX + 10, posY - 16, 450.0).render(ms);
        ms.func_227865_b_();
    }

    private static final class TooltipScreen
    extends Screen {
        private TooltipScreen(ITextComponent p_i51108_1_) {
            super(p_i51108_1_);
        }

        public void func_231158_b_(Minecraft mc, int width, int height) {
            this.field_230706_i_ = mc;
            this.field_230707_j_ = mc.func_175599_af();
            this.field_230712_o_ = mc.field_71466_p;
            this.field_230708_k_ = width;
            this.field_230709_l_ = height;
        }
    }
}

