/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankConnectivityHandler;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidTankItem
extends BlockItem {
    public FluidTankItem(Block p_i48527_1_, Item.Properties p_i48527_2_) {
        super(p_i48527_1_, p_i48527_2_);
    }

    public ActionResultType func_195942_a(BlockItemUseContext ctx) {
        ActionResultType initialResult = super.func_195942_a(ctx);
        if (!initialResult.func_226246_a_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean func_195943_a(BlockPos p_195943_1_, World p_195943_2_, PlayerEntity p_195943_3_, ItemStack p_195943_4_, BlockState p_195943_5_) {
        MinecraftServer minecraftserver = p_195943_2_.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        CompoundNBT nbt = p_195943_4_.func_179543_a("BlockEntityTag");
        if (nbt != null) {
            FluidStack fluid;
            nbt.func_82580_o("Luminosity");
            nbt.func_82580_o("Size");
            nbt.func_82580_o("Height");
            nbt.func_82580_o("Controller");
            nbt.func_82580_o("LastKnownPos");
            if (nbt.func_74764_b("TankContent") && !(fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("TankContent"))).isEmpty()) {
                fluid.setAmount(Math.min(FluidTankTileEntity.getCapacityMultiplier(), fluid.getAmount()));
                nbt.func_218657_a("TankContent", (INBT)fluid.writeToNBT(new CompoundNBT()));
            }
        }
        return super.func_195943_a(p_195943_1_, p_195943_2_, p_195943_3_, p_195943_4_, p_195943_5_);
    }

    private void tryMultiPlace(BlockItemUseContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        PlayerEntity player = ctx.func_195999_j();
        if (player == null) {
            return;
        }
        if (player.func_225608_bj_()) {
            return;
        }
        Direction face = ctx.func_196000_l();
        if (!face.func_176740_k().func_200128_b()) {
            return;
        }
        ItemStack stack = ctx.func_195996_i();
        World world = ctx.func_195991_k();
        BlockState placedOnState = world.func_180495_p(placedOnPos = (pos = ctx.func_195995_a()).func_177972_a(face.func_176734_d()));
        if (!FluidTankBlock.isTank(placedOnState)) {
            return;
        }
        FluidTankTileEntity tankAt = FluidTankConnectivityHandler.anyTankAt((IBlockReader)world, placedOnPos);
        if (tankAt == null) {
            return;
        }
        FluidTankTileEntity controllerTE = tankAt.getControllerTE();
        if (controllerTE == null) {
            return;
        }
        int width = controllerTE.width;
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerTE.func_174877_v().func_177977_b() : controllerTE.func_174877_v().func_177981_b(controllerTE.height);
        if (startPos.func_177956_o() != pos.func_177956_o()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.func_177982_a(xOffset, 0, zOffset);
                blockState = world.func_180495_p(offsetPos);
                if (FluidTankBlock.isTank(blockState)) continue;
                if (!blockState.func_185904_a().func_76222_j()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.func_184812_l_() && stack.func_190916_E() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.func_177982_a(xOffset, 0, zOffset);
                blockState = world.func_180495_p(offsetPos);
                if (FluidTankBlock.isTank(blockState)) continue;
                BlockItemUseContext context = BlockItemUseContext.func_221536_a((BlockItemUseContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().func_74757_a("SilenceTankSound", true);
                super.func_195942_a(context);
                player.getPersistentData().func_82580_o("SilenceTankSound");
            }
        }
    }
}

