/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.actors.ItemDrainTileEntity;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.tileEntity.ComparatorUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ItemDrainBlock
extends Block
implements IWrenchable,
ITE<ItemDrainTileEntity> {
    public ItemDrainBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        try {
            ItemDrainTileEntity te = (ItemDrainTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
            if (!heldItem.func_190926_b()) {
                te.internalTank.allowInsertion();
                ActionResultType tryExchange = this.tryExchange(worldIn, player, handIn, heldItem, te);
                te.internalTank.forbidInsertion();
                if (tryExchange.func_226246_a_()) {
                    return tryExchange;
                }
            }
            ItemStack heldItemStack = te.getHeldItemStack();
            if (!worldIn.field_72995_K && !heldItemStack.func_190926_b()) {
                player.field_71071_by.func_191975_a(worldIn, heldItemStack);
                te.heldItem = null;
                te.notifyUpdate();
            }
            return ActionResultType.SUCCESS;
        }
        catch (ITE.TileEntityException tileEntityException) {
            return ActionResultType.PASS;
        }
    }

    protected ActionResultType tryExchange(World worldIn, PlayerEntity player, Hand handIn, ItemStack heldItem, ItemDrainTileEntity te) {
        if (FluidHelper.tryEmptyItemIntoTE(worldIn, player, handIn, heldItem, te)) {
            return ActionResultType.SUCCESS;
        }
        if (EmptyingByBasin.canItemBeEmptied(worldIn, heldItem)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.CASING_13PX.get(Direction.UP);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasTileEntity() || state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            ItemStack heldItemStack = te.getHeldItemStack();
            if (!heldItemStack.func_190926_b()) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)heldItemStack);
            }
        });
        worldIn.func_175713_t(pos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.ITEM_DRAIN.create();
    }

    @Override
    public Class<ItemDrainTileEntity> getTileEntityClass() {
        return ItemDrainTileEntity.class;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return ComparatorUtil.levelOfSmartFluidTank((IBlockReader)worldIn, pos);
    }
}

