/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.fluids.actors.FluidDrainingBehaviour;
import com.simibubi.create.content.contraptions.fluids.actors.FluidFillingBehaviour;
import com.simibubi.create.content.contraptions.fluids.actors.HosePulleyTileEntity;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class HosePulleyBlock
extends HorizontalKineticBlock
implements ITE<HosePulleyTileEntity> {
    public HosePulleyBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176746_e().func_176740_k();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction preferredHorizontalFacing = this.getPreferredHorizontalFacing(context);
        return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)(preferredHorizontalFacing != null ? preferredHorizontalFacing.func_176735_f() : context.func_195992_f().func_176734_d()));
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176746_e() == face;
    }

    public static boolean hasPipeTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176735_f() == face;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.HOSE_PULLEY.create();
    }

    @Override
    public Direction getPreferredHorizontalFacing(BlockItemUseContext context) {
        Direction fromParent = super.getPreferredHorizontalFacing(context);
        if (fromParent != null) {
            return fromParent;
        }
        Direction prefferedSide = null;
        for (Direction facing : Iterate.horizontalDirections) {
            BlockPos pos = context.func_195995_a().func_177972_a(facing);
            BlockState blockState = context.func_195991_k().func_180495_p(pos);
            if (!FluidPipeBlock.canConnectTo((IBlockDisplayReader)context.func_195991_k(), pos, blockState, facing)) continue;
            if (prefferedSide != null && prefferedSide.func_176740_k() != facing.func_176740_k()) {
                prefferedSide = null;
                break;
            }
            prefferedSide = facing;
        }
        return prefferedSide == null ? null : prefferedSide.func_176734_d();
    }

    public void func_196243_a(BlockState p_196243_1_, World world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        if (p_196243_1_.hasTileEntity() && (p_196243_1_.func_177230_c() != p_196243_4_.func_177230_c() || !p_196243_4_.hasTileEntity())) {
            TileEntityBehaviour.destroy((IBlockReader)world, pos, FluidDrainingBehaviour.TYPE);
            TileEntityBehaviour.destroy((IBlockReader)world, pos, FluidFillingBehaviour.TYPE);
            world.func_175713_t(pos);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.PULLEY.get(((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176746_e().func_176740_k());
    }

    @Override
    public Class<HosePulleyTileEntity> getTileEntityClass() {
        return HosePulleyTileEntity.class;
    }
}

