/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import java.util.Map;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;

public class MinecartSim2020 {
    private static final Map<RailShape, Pair<Vector3i, Vector3i>> MATRIX = (Map)Util.func_200696_a((Object)Maps.newEnumMap(RailShape.class), map -> {
        Vector3i west = Direction.WEST.func_176730_m();
        Vector3i east = Direction.EAST.func_176730_m();
        Vector3i north = Direction.NORTH.func_176730_m();
        Vector3i south = Direction.SOUTH.func_176730_m();
        map.put(RailShape.NORTH_SOUTH, Pair.of((Object)north, (Object)south));
        map.put(RailShape.EAST_WEST, Pair.of((Object)west, (Object)east));
        map.put(RailShape.ASCENDING_EAST, Pair.of((Object)west.func_177977_b(), (Object)east));
        map.put(RailShape.ASCENDING_WEST, Pair.of((Object)west, (Object)east.func_177977_b()));
        map.put(RailShape.ASCENDING_NORTH, Pair.of((Object)north, (Object)south.func_177977_b()));
        map.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)north.func_177977_b(), (Object)south));
        map.put(RailShape.SOUTH_EAST, Pair.of((Object)south, (Object)east));
        map.put(RailShape.SOUTH_WEST, Pair.of((Object)south, (Object)west));
        map.put(RailShape.NORTH_WEST, Pair.of((Object)north, (Object)west));
        map.put(RailShape.NORTH_EAST, Pair.of((Object)north, (Object)east));
    });

    public static Vector3d predictNextPositionOf(AbstractMinecartEntity cart) {
        Vector3d position = cart.func_213303_ch();
        Vector3d motion = cart.func_213322_ci();
        return position.func_178787_e(motion);
    }

    public static boolean canAddMotion(AbstractMinecartEntity c) {
        if (c instanceof FurnaceMinecartEntity) {
            return MathHelper.func_219806_b((double)((FurnaceMinecartEntity)c).field_94111_a, (double)0.0) && MathHelper.func_219806_b((double)((FurnaceMinecartEntity)c).field_94109_b, (double)0.0);
        }
        LazyOptional capability = c.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
        return !capability.isPresent() || !((MinecartController)capability.orElse(null)).isStalled();
    }

    public static void moveCartAlongTrack(AbstractMinecartEntity cart, Vector3d forcedMovement, BlockPos cartPos, BlockState trackState) {
        double d14;
        if (forcedMovement.equals((Object)Vector3d.field_186680_a)) {
            return;
        }
        Vector3d previousMotion = cart.func_213322_ci();
        cart.field_70143_R = 0.0f;
        double x = cart.func_226277_ct_();
        double y = cart.func_226278_cu_();
        double z = cart.func_226281_cx_();
        double actualX = x;
        double actualY = y;
        double actualZ = z;
        Vector3d actualVec = cart.func_70489_a(actualX, actualY, actualZ);
        actualY = cartPos.func_177956_o() + 1;
        AbstractRailBlock abstractrailblock = (AbstractRailBlock)trackState.func_177230_c();
        RailShape railshape = abstractrailblock.getRailDirection(trackState, (IBlockReader)cart.field_70170_p, cartPos, cart);
        switch (railshape) {
            case ASCENDING_EAST: {
                forcedMovement = forcedMovement.func_72441_c(-1.0 * cart.getSlopeAdjustment(), 0.0, 0.0);
                actualY += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                forcedMovement = forcedMovement.func_72441_c(cart.getSlopeAdjustment(), 0.0, 0.0);
                actualY += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                forcedMovement = forcedMovement.func_72441_c(0.0, 0.0, cart.getSlopeAdjustment());
                actualY += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                forcedMovement = forcedMovement.func_72441_c(0.0, 0.0, -1.0 * cart.getSlopeAdjustment());
                actualY += 1.0;
            }
        }
        Pair<Vector3i, Vector3i> pair = MATRIX.get(railshape);
        Vector3i Vector3i2 = (Vector3i)pair.getFirst();
        Vector3i Vector3i1 = (Vector3i)pair.getSecond();
        double d4 = Vector3i1.func_177958_n() - Vector3i2.func_177958_n();
        double d5 = Vector3i1.func_177952_p() - Vector3i2.func_177952_p();
        double d7 = forcedMovement.field_72450_a * d4 + forcedMovement.field_72449_c * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d23 = (double)cartPos.func_177958_n() + 0.5 + (double)Vector3i2.func_177958_n() * 0.5;
        double d10 = (double)cartPos.func_177952_p() + 0.5 + (double)Vector3i2.func_177952_p() * 0.5;
        double d12 = (double)cartPos.func_177958_n() + 0.5 + (double)Vector3i1.func_177958_n() * 0.5;
        double d13 = (double)cartPos.func_177952_p() + 0.5 + (double)Vector3i1.func_177952_p() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = actualZ - (double)cartPos.func_177952_p();
        } else if (d5 == 0.0) {
            d14 = actualX - (double)cartPos.func_177958_n();
        } else {
            double d15 = actualX - d23;
            double d16 = actualZ - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        actualX = d23 + d4 * d14;
        actualZ = d10 + d5 * d14;
        cart.func_70107_b(actualX, actualY, actualZ);
        cart.func_213317_d(forcedMovement);
        cart.moveMinecartOnRail(cartPos);
        x = cart.func_226277_ct_();
        y = cart.func_226278_cu_();
        z = cart.func_226281_cx_();
        if (Vector3i2.func_177956_o() != 0 && MathHelper.func_76128_c((double)x) - cartPos.func_177958_n() == Vector3i2.func_177958_n() && MathHelper.func_76128_c((double)z) - cartPos.func_177952_p() == Vector3i2.func_177952_p()) {
            cart.func_70107_b(x, y + (double)Vector3i2.func_177956_o(), z);
        } else if (Vector3i1.func_177956_o() != 0 && MathHelper.func_76128_c((double)x) - cartPos.func_177958_n() == Vector3i1.func_177958_n() && MathHelper.func_76128_c((double)z) - cartPos.func_177952_p() == Vector3i1.func_177952_p()) {
            cart.func_70107_b(x, y + (double)Vector3i1.func_177956_o(), z);
        }
        x = cart.func_226277_ct_();
        y = cart.func_226278_cu_();
        z = cart.func_226281_cx_();
        Vector3d Vector3d3 = cart.func_70489_a(x, y, z);
        if (Vector3d3 != null && actualVec != null) {
            double d17 = (actualVec.field_72448_b - Vector3d3.field_72448_b) * 0.05;
            Vector3d Vector3d4 = cart.func_213322_ci();
            double d18 = Math.sqrt(Entity.func_213296_b((Vector3d)Vector3d4));
            if (d18 > 0.0) {
                cart.func_213317_d(Vector3d4.func_216372_d((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            cart.func_70107_b(x, Vector3d3.field_72448_b, z);
        }
        x = cart.func_226277_ct_();
        y = cart.func_226278_cu_();
        z = cart.func_226281_cx_();
        int j = MathHelper.func_76128_c((double)x);
        int i = MathHelper.func_76128_c((double)z);
        if (j != cartPos.func_177958_n() || i != cartPos.func_177952_p()) {
            Vector3d Vector3d5 = cart.func_213322_ci();
            double d26 = Math.sqrt(Entity.func_213296_b((Vector3d)Vector3d5));
            cart.func_213293_j(d26 * (double)(j - cartPos.func_177958_n()), Vector3d5.field_72448_b, d26 * (double)(i - cartPos.func_177952_p()));
        }
        cart.func_213317_d(previousMotion);
    }

    public static Vector3d getRailVec(RailShape shape) {
        switch (shape) {
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: 
            case NORTH_SOUTH: {
                return new Vector3d(0.0, 0.0, 1.0);
            }
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case EAST_WEST: {
                return new Vector3d(1.0, 0.0, 0.0);
            }
            case NORTH_EAST: 
            case SOUTH_WEST: {
                return new Vector3d(1.0, 0.0, 1.0).func_72432_b();
            }
            case NORTH_WEST: 
            case SOUTH_EAST: {
                return new Vector3d(1.0, 0.0, -1.0).func_72432_b();
            }
        }
        return new Vector3d(0.0, 1.0, 0.0);
    }
}

