/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionAttributes;
import com.simibubi.create.foundation.render.backend.BufferedModel;
import com.simibubi.create.foundation.render.backend.gl.GlBuffer;
import com.simibubi.create.foundation.render.backend.gl.GlPrimitiveType;
import com.simibubi.create.foundation.render.backend.gl.attrib.VertexFormat;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class ContraptionModel
extends BufferedModel {
    public static final VertexFormat FORMAT = VertexFormat.builder().addAttributes(ContraptionAttributes.class).build();
    protected GlPrimitiveType eboIndexType;
    protected GlBuffer ebo;

    public ContraptionModel(BufferBuilder buf) {
        super(buf);
    }

    @Override
    protected void init() {
        super.init();
        this.createEBO();
    }

    @Override
    protected void doRender() {
        this.modelVBO.bind();
        this.ebo.bind();
        this.setupAttributes();
        GL20.glDrawElements((int)7, (int)this.vertexCount, (int)this.eboIndexType.getGlConstant(), (long)0L);
        int numAttributes = this.getTotalShaderAttributeCount();
        for (int i = 0; i <= numAttributes; ++i) {
            GL20.glDisableVertexAttribArray((int)i);
        }
        this.ebo.unbind();
        this.modelVBO.unbind();
    }

    protected final void createEBO() {
        this.ebo = new GlBuffer(34963);
        this.eboIndexType = GlPrimitiveType.UINT;
        int indicesSize = this.vertexCount * this.eboIndexType.getSize();
        this.ebo.bind();
        GL15.glBufferData((int)34963, (long)indicesSize, (int)35044);
        this.ebo.map(indicesSize, indices -> {
            for (int i = 0; i < this.vertexCount; ++i) {
                indices.putInt(i);
            }
        });
        this.ebo.unbind();
    }

    @Override
    protected void copyVertex(ByteBuffer to, int vertex) {
        to.putFloat(this.getX(this.template, vertex));
        to.putFloat(this.getY(this.template, vertex));
        to.putFloat(this.getZ(this.template, vertex));
        to.put(this.getNX(this.template, vertex));
        to.put(this.getNY(this.template, vertex));
        to.put(this.getNZ(this.template, vertex));
        to.putFloat(this.getU(this.template, vertex));
        to.putFloat(this.getV(this.template, vertex));
        to.put(this.getR(this.template, vertex));
        to.put(this.getG(this.template, vertex));
        to.put(this.getB(this.template, vertex));
        to.put(this.getA(this.template, vertex));
        int light = this.getLight(this.template, vertex);
        byte sky = (byte)(LightTexture.func_228454_b_((int)light) << 4);
        byte block = (byte)(LightTexture.func_228450_a_((int)light) << 4);
        to.put(block);
        to.put(sky);
    }

    @Override
    protected VertexFormat getModelFormat() {
        return FORMAT;
    }

    @Override
    protected void deleteInternal() {
        super.deleteInternal();
        this.ebo.delete();
    }
}

