/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public abstract class AbstractChassisBlock
extends RotatedPillarBlock
implements IWrenchable {
    public AbstractChassisBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CHASSIS.create();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_175142_cm()) {
            return ActionResultType.PASS;
        }
        ItemStack heldItem = player.func_184586_b(handIn);
        boolean isSlimeBall = heldItem.func_77973_b().func_206844_a((ITag)Tags.Items.SLIMEBALLS) || AllItems.SUPER_GLUE.isIn(heldItem);
        BooleanProperty affectedSide = this.getGlueableSide(state, hit.func_216354_b());
        if (affectedSide == null) {
            return ActionResultType.PASS;
        }
        if (isSlimeBall && ((Boolean)state.func_177229_b((Property)affectedSide)).booleanValue()) {
            for (Direction face : Iterate.directions) {
                BooleanProperty glueableSide = this.getGlueableSide(state, face);
                if (glueableSide == null || ((Boolean)state.func_177229_b((Property)glueableSide)).booleanValue() || !this.glueAllowedOnSide((IBlockReader)worldIn, pos, state, face)) continue;
                if (worldIn.field_72995_K) {
                    Vector3d vec = hit.func_216347_e();
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197592_C, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0);
                    return ActionResultType.SUCCESS;
                }
                worldIn.func_184133_a(null, pos, AllSoundEvents.SLIME_ADDED.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                state = (BlockState)state.func_206870_a((Property)glueableSide, (Comparable)Boolean.valueOf(true));
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, state);
            }
            return ActionResultType.SUCCESS;
        }
        if (!(heldItem.func_190926_b() && player.func_225608_bj_() || isSlimeBall)) {
            return ActionResultType.PASS;
        }
        if ((Boolean)state.func_177229_b((Property)affectedSide) == isSlimeBall) {
            return ActionResultType.PASS;
        }
        if (!this.glueAllowedOnSide((IBlockReader)worldIn, pos, state, hit.func_216354_b())) {
            return ActionResultType.PASS;
        }
        if (worldIn.field_72995_K) {
            Vector3d vec = hit.func_216347_e();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197592_C, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0);
            return ActionResultType.SUCCESS;
        }
        worldIn.func_184133_a(null, pos, AllSoundEvents.SLIME_ADDED.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)affectedSide, (Comparable)Boolean.valueOf(isSlimeBall)));
        return ActionResultType.SUCCESS;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        BooleanProperty glueableSide;
        if (rotation == Rotation.NONE) {
            return state;
        }
        BlockState rotated = super.func_185499_a(state, rotation);
        for (Direction face : Iterate.directions) {
            glueableSide = this.getGlueableSide(rotated, face);
            if (glueableSide == null) continue;
            rotated = (BlockState)rotated.func_206870_a((Property)glueableSide, (Comparable)Boolean.valueOf(false));
        }
        for (Direction face : Iterate.directions) {
            Direction rotatedFacing;
            BooleanProperty rotatedGlueableSide;
            glueableSide = this.getGlueableSide(state, face);
            if (glueableSide == null || !((Boolean)state.func_177229_b((Property)glueableSide)).booleanValue() || (rotatedGlueableSide = this.getGlueableSide(rotated, rotatedFacing = rotation.func_185831_a(face))) == null) continue;
            rotated = (BlockState)rotated.func_206870_a((Property)rotatedGlueableSide, (Comparable)Boolean.valueOf(true));
        }
        return rotated;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        BooleanProperty glueableSide;
        if (mirrorIn == Mirror.NONE) {
            return state;
        }
        BlockState mirrored = state;
        for (Direction face : Iterate.directions) {
            glueableSide = this.getGlueableSide(mirrored, face);
            if (glueableSide == null) continue;
            mirrored = (BlockState)mirrored.func_206870_a((Property)glueableSide, (Comparable)Boolean.valueOf(false));
        }
        for (Direction face : Iterate.directions) {
            Direction mirroredFacing;
            BooleanProperty mirroredGlueableSide;
            glueableSide = this.getGlueableSide(state, face);
            if (glueableSide == null || !((Boolean)state.func_177229_b((Property)glueableSide)).booleanValue() || (mirroredGlueableSide = this.getGlueableSide(mirrored, mirroredFacing = mirrorIn.func_185803_b(face))) == null) continue;
            mirrored = (BlockState)mirrored.func_206870_a((Property)mirroredGlueableSide, (Comparable)Boolean.valueOf(true));
        }
        return mirrored;
    }

    public abstract BooleanProperty getGlueableSide(BlockState var1, Direction var2);

    protected boolean glueAllowedOnSide(IBlockReader world, BlockPos pos, BlockState state, Direction side) {
        return true;
    }
}

