/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.foundation.block.ProperDirectionalBlock;
import com.simibubi.create.foundation.utility.DyeHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SailBlock
extends ProperDirectionalBlock {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());
    private final boolean frame;

    public static SailBlock frame(AbstractBlock.Properties properties) {
        return new SailBlock(properties, true);
    }

    public static SailBlock withCanvas(AbstractBlock.Properties properties) {
        return new SailBlock(properties, false);
    }

    protected SailBlock(AbstractBlock.Properties p_i48415_1_, boolean frame) {
        super(p_i48415_1_);
        this.frame = frame;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return (BlockState)state.func_206870_a((Property)field_176387_N, (Comparable)((Direction)state.func_177229_b((Property)field_176387_N)).func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack heldItem = player.func_184586_b(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.func_77973_b(), player, hand, ray);
        }
        if (heldItem.func_77973_b() instanceof ShearsItem) {
            if (!world.field_72995_K) {
                this.applyDye(state, world, pos, null);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.frame) {
            return ActionResultType.PASS;
        }
        for (DyeColor color : DyeColor.values()) {
            if (!heldItem.func_77973_b().func_206844_a(DyeHelper.getTagOfDye(color))) continue;
            if (!world.field_72995_K) {
                this.applyDye(state, world, pos, color);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void applyDye(BlockState state, World world, BlockPos pos, @Nullable DyeColor color) {
        BlockState newState = (BlockState)(color == null ? AllBlocks.SAIL_FRAME : AllBlocks.DYED_SAILS[color.ordinal()]).getDefaultState().func_206870_a((Property)field_176387_N, state.func_177229_b((Property)field_176387_N));
        if (state != newState) {
            world.func_175656_a(pos, newState);
            return;
        }
        for (Direction d : Iterate.directions) {
            BlockPos offset;
            BlockState adjacentState;
            Block block;
            if (d.func_176740_k() == ((Direction)state.func_177229_b((Property)field_176387_N)).func_176740_k() || !((block = (adjacentState = world.func_180495_p(offset = pos.func_177972_a(d))).func_177230_c()) instanceof SailBlock) || ((SailBlock)block).frame || state == adjacentState) continue;
            world.func_175656_a(offset, newState);
            return;
        }
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        frontier.add(pos);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int timeout = 100;
        while (!frontier.isEmpty() && timeout-- >= 0) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            visited.add(currentPos);
            for (Direction d : Iterate.directions) {
                BlockState adjacentState;
                Block block;
                BlockPos offset;
                if (d.func_176740_k() == ((Direction)state.func_177229_b((Property)field_176387_N)).func_176740_k() || visited.contains(offset = currentPos.func_177972_a(d)) || !((block = (adjacentState = world.func_180495_p(offset)).func_177230_c()) instanceof SailBlock) || ((SailBlock)block).frame && color != null) continue;
                if (state != adjacentState) {
                    world.func_175656_a(offset, newState);
                }
                frontier.add(offset);
                visited.add(offset);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return (this.frame ? AllShapes.SAIL_FRAME : AllShapes.SAIL).get((Direction)state.func_177229_b((Property)field_176387_N));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        if (this.frame) {
            return AllShapes.SAIL_FRAME_COLLISION.get((Direction)state.func_177229_b((Property)field_176387_N));
        }
        return this.func_220053_a(state, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        if (pickBlock.func_190926_b()) {
            return ((SailBlock)AllBlocks.SAIL.get()).getPickBlock(state, target, world, pos, player);
        }
        return pickBlock;
    }

    public void func_180658_a(World p_180658_1_, BlockPos p_180658_2_, Entity p_180658_3_, float p_180658_4_) {
        if (this.frame) {
            super.func_180658_a(p_180658_1_, p_180658_2_, p_180658_3_, p_180658_4_);
        }
        super.func_180658_a(p_180658_1_, p_180658_2_, p_180658_3_, 0.0f);
    }

    public void func_176216_a(IBlockReader p_176216_1_, Entity p_176216_2_) {
        if (this.frame || p_176216_2_.func_226272_bl_()) {
            super.func_176216_a(p_176216_1_, p_176216_2_);
        } else {
            this.bounce(p_176216_2_);
        }
    }

    private void bounce(Entity p_226860_1_) {
        Vector3d Vector3d2 = p_226860_1_.func_213322_ci();
        if (Vector3d2.field_72448_b < 0.0) {
            double d0 = p_226860_1_ instanceof LivingEntity ? 1.0 : 0.8;
            p_226860_1_.func_213293_j(Vector3d2.field_72450_a, -Vector3d2.field_72448_b * (double)0.26f * d0, Vector3d2.field_72449_c);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return i -> AllBlocks.SAIL.isIn((ItemStack)i) || AllBlocks.SAIL_FRAME.isIn((ItemStack)i);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> s.func_177230_c() instanceof SailBlock;
        }

        @Override
        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.func_216347_e(), ((Direction)state.func_177229_b((Property)field_176387_N)).func_176740_k(), (Direction dir) -> world.func_180495_p(pos.func_177972_a(dir)).func_185904_a().func_76222_j());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vector3i)pos.func_177972_a(directions.get(0)), s -> (BlockState)s.func_206870_a((Property)DirectionalBlock.field_176387_N, state.func_177229_b((Property)DirectionalBlock.field_176387_N)));
        }
    }
}

