/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.actors.AttachedActorBlock;
import com.simibubi.create.content.contraptions.components.actors.HarvesterBlock;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.content.contraptions.components.fan.NozzleBlock;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.SailBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankConnectivityHandler;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkBlock;
import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.GrindstoneBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockMovementTraits {
    public static boolean movementNecessary(BlockState state, World world, BlockPos pos) {
        if (BlockMovementTraits.isBrittle(state)) {
            return true;
        }
        if (state.func_177230_c() instanceof FenceGateBlock) {
            return true;
        }
        if (state.func_185904_a().func_76222_j()) {
            return false;
        }
        return !state.func_196952_d((IBlockReader)world, pos).func_197766_b();
    }

    public static boolean movementAllowed(BlockState state, World world, BlockPos pos) {
        TileEntity te;
        Block block = state.func_177230_c();
        if (block instanceof AbstractChassisBlock) {
            return true;
        }
        if (state.func_185887_b((IBlockReader)world, pos) == -1.0f) {
            return false;
        }
        if (AllTags.AllBlockTags.NON_MOVABLE.matches(state)) {
            return false;
        }
        if (block instanceof MechanicalPistonBlock && state.func_177229_b(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.MOVING) {
            return true;
        }
        if (block instanceof MechanicalBearingBlock && (te = world.func_175625_s(pos)) instanceof MechanicalBearingTileEntity) {
            return !((MechanicalBearingTileEntity)te).isRunning();
        }
        if (block instanceof ClockworkBearingBlock && (te = world.func_175625_s(pos)) instanceof ClockworkBearingTileEntity) {
            return !((ClockworkBearingTileEntity)te).isRunning();
        }
        if (block instanceof PulleyBlock && (te = world.func_175625_s(pos)) instanceof PulleyTileEntity) {
            return !((PulleyTileEntity)te).running;
        }
        if (AllBlocks.BELT.has(state)) {
            return true;
        }
        if (state.func_177230_c() instanceof GrindstoneBlock) {
            return true;
        }
        return state.func_185905_o() != PushReaction.BLOCK;
    }

    public static boolean isBrittle(BlockState state) {
        Block block = state.func_177230_c();
        if (state.func_235901_b_((Property)BlockStateProperties.field_222514_j)) {
            return true;
        }
        if (block instanceof LadderBlock) {
            return true;
        }
        if (block instanceof TorchBlock) {
            return true;
        }
        if (block instanceof AbstractPressurePlateBlock) {
            return true;
        }
        if (block instanceof HorizontalFaceBlock && !(block instanceof GrindstoneBlock)) {
            return true;
        }
        if (block instanceof CartAssemblerBlock) {
            return false;
        }
        if (block instanceof AbstractRailBlock) {
            return true;
        }
        if (block instanceof RedstoneDiodeBlock) {
            return true;
        }
        if (block instanceof RedstoneWireBlock) {
            return true;
        }
        if (block instanceof CarpetBlock) {
            return true;
        }
        return AllTags.AllBlockTags.BRITTLE.tag.func_230235_a_((Object)block);
    }

    public static boolean isBlockAttachedTowards(IBlockReader world, BlockPos pos, BlockState state, Direction direction) {
        Block block = state.func_177230_c();
        if (block instanceof LadderBlock) {
            return state.func_177229_b((Property)LadderBlock.field_176382_a) == direction.func_176734_d();
        }
        if (block instanceof WallTorchBlock) {
            return state.func_177229_b((Property)WallTorchBlock.field_196532_a) == direction.func_176734_d();
        }
        if (block instanceof AbstractPressurePlateBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof DoorBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedstoneLinkBlock) {
            return direction.func_176734_d() == state.func_177229_b((Property)RedstoneLinkBlock.field_176387_N);
        }
        if (block instanceof FlowerPotBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedstoneDiodeBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedstoneWireBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof CarpetBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedstoneWallTorchBlock) {
            return state.func_177229_b((Property)RedstoneWallTorchBlock.field_196530_b) == direction.func_176734_d();
        }
        if (block instanceof TorchBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof HorizontalFaceBlock) {
            AttachFace attachFace = (AttachFace)state.func_177229_b((Property)HorizontalFaceBlock.field_196366_M);
            if (attachFace == AttachFace.CEILING) {
                return direction == Direction.UP;
            }
            if (attachFace == AttachFace.FLOOR) {
                return direction == Direction.DOWN;
            }
            if (attachFace == AttachFace.WALL) {
                return direction.func_176734_d() == state.func_177229_b((Property)HorizontalFaceBlock.field_185512_D);
            }
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_222514_j)) {
            return direction == ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_222514_j) != false ? Direction.UP : Direction.DOWN);
        }
        if (block instanceof AbstractRailBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof AttachedActorBlock) {
            return direction == ((Direction)state.func_177229_b((Property)HarvesterBlock.field_185512_D)).func_176734_d();
        }
        if (block instanceof HandCrankBlock) {
            return direction == ((Direction)state.func_177229_b((Property)HandCrankBlock.FACING)).func_176734_d();
        }
        if (block instanceof NozzleBlock) {
            return direction == ((Direction)state.func_177229_b((Property)NozzleBlock.field_176387_N)).func_176734_d();
        }
        if (block instanceof EngineBlock) {
            return direction == ((Direction)state.func_177229_b((Property)EngineBlock.field_185512_D)).func_176734_d();
        }
        if (block instanceof BellBlock) {
            BellAttachment attachment = (BellAttachment)state.func_177229_b((Property)BlockStateProperties.field_222511_P);
            if (attachment == BellAttachment.FLOOR) {
                return direction == Direction.DOWN;
            }
            if (attachment == BellAttachment.CEILING) {
                return direction == Direction.UP;
            }
            return direction == state.func_177229_b((Property)HorizontalBlock.field_185512_D);
        }
        if (state.func_177230_c() instanceof SailBlock) {
            return direction.func_176740_k() != ((Direction)state.func_177229_b((Property)SailBlock.field_176387_N)).func_176740_k();
        }
        if (state.func_177230_c() instanceof FluidTankBlock) {
            return FluidTankConnectivityHandler.isConnected(world, pos, pos.func_177972_a(direction));
        }
        if (AllBlocks.STICKER.has(state) && ((Boolean)state.func_177229_b((Property)StickerBlock.EXTENDED)).booleanValue()) {
            return direction == state.func_177229_b((Property)StickerBlock.field_176387_N) && !BlockMovementTraits.notSupportive(world.func_180495_p(pos.func_177972_a(direction)), direction.func_176734_d());
        }
        return false;
    }

    public static boolean notSupportive(BlockState state, Direction facing) {
        if (AllBlocks.MECHANICAL_DRILL.has(state)) {
            return state.func_177229_b((Property)BlockStateProperties.field_208155_H) == facing;
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            return state.func_177229_b((Property)BlockStateProperties.field_208155_H) == facing;
        }
        if (AllBlocks.CART_ASSEMBLER.has(state)) {
            return Direction.DOWN == facing;
        }
        if (AllBlocks.MECHANICAL_SAW.has(state)) {
            return state.func_177229_b((Property)BlockStateProperties.field_208155_H) == facing;
        }
        if (AllBlocks.PORTABLE_STORAGE_INTERFACE.has(state)) {
            return state.func_177229_b((Property)PortableStorageInterfaceBlock.field_176387_N) == facing;
        }
        if (state.func_177230_c() instanceof AttachedActorBlock) {
            return state.func_177229_b((Property)BlockStateProperties.field_208157_J) == facing;
        }
        if (AllBlocks.ROPE_PULLEY.has(state)) {
            return facing == Direction.DOWN;
        }
        if (state.func_177230_c() instanceof CarpetBlock) {
            return facing == Direction.UP;
        }
        if (state.func_177230_c() instanceof SailBlock) {
            return facing.func_176740_k() == ((Direction)state.func_177229_b((Property)SailBlock.field_176387_N)).func_176740_k();
        }
        if (AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            return facing.func_176740_k() != ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176740_k();
        }
        if (AllBlocks.MECHANICAL_PISTON_HEAD.has(state)) {
            return facing.func_176740_k() != ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176740_k();
        }
        if (AllBlocks.STICKER.has(state) && !((Boolean)state.func_177229_b((Property)StickerBlock.EXTENDED)).booleanValue()) {
            return facing == state.func_177229_b((Property)StickerBlock.field_176387_N);
        }
        return BlockMovementTraits.isBrittle(state);
    }
}

