/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.foundation.config.AllConfigs;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AssemblyException
extends Exception {
    private static final long serialVersionUID = 1L;
    public final ITextComponent component;
    private BlockPos position = null;

    public static void write(CompoundNBT compound, AssemblyException exception) {
        if (exception == null) {
            return;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Component", ITextComponent.Serializer.func_150696_a((ITextComponent)exception.component));
        if (exception.hasPosition()) {
            nbt.func_74772_a("Position", exception.getPosition().func_218275_a());
        }
        compound.func_218657_a("LastException", (INBT)nbt);
    }

    public static AssemblyException read(CompoundNBT compound) {
        if (!compound.func_74764_b("LastException")) {
            return null;
        }
        CompoundNBT nbt = compound.func_74775_l("LastException");
        String string = nbt.func_74779_i("Component");
        AssemblyException exception = new AssemblyException((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)string));
        if (nbt.func_74764_b("Position")) {
            exception.position = BlockPos.func_218283_e((long)nbt.func_74763_f("Position"));
        }
        return exception;
    }

    public AssemblyException(ITextComponent component) {
        this.component = component;
    }

    public AssemblyException(String langKey, Object ... objects) {
        this((ITextComponent)new TranslationTextComponent("create.gui.assembly.exception." + langKey, objects));
    }

    public static AssemblyException unmovableBlock(BlockPos pos, BlockState state) {
        AssemblyException e = new AssemblyException("unmovableBlock", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), new TranslationTextComponent(state.func_177230_c().func_149739_a()));
        e.position = pos;
        return e;
    }

    public static AssemblyException unloadedChunk(BlockPos pos) {
        AssemblyException e = new AssemblyException("chunkNotLoaded", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        e.position = pos;
        return e;
    }

    public static AssemblyException structureTooLarge() {
        return new AssemblyException("structureTooLarge", AllConfigs.SERVER.kinetics.maxBlocksMoved.get());
    }

    public static AssemblyException tooManyPistonPoles() {
        return new AssemblyException("tooManyPistonPoles", AllConfigs.SERVER.kinetics.maxPistonPoles.get());
    }

    public static AssemblyException noPistonPoles() {
        return new AssemblyException("noPistonPoles", new Object[0]);
    }

    public static AssemblyException notEnoughSails(int sails) {
        return new AssemblyException("not_enough_sails", sails, AllConfigs.SERVER.kinetics.minimumWindmillSails.get());
    }

    public boolean hasPosition() {
        return this.position != null;
    }

    public BlockPos getPosition() {
        return this.position;
    }
}

