/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.saw;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.actors.BlockBreakingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.saw.CuttingRecipe;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.saw.SawFilterSlot;
import com.simibubi.create.content.contraptions.processing.ProcessingInventory;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.recipe.RecipeConditions;
import com.simibubi.create.foundation.utility.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.block.KelpBlock;
import net.minecraft.block.KelpTopBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.StonecuttingRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SawTileEntity
extends BlockBreakingKineticTileEntity {
    private static final Object cuttingRecipesKey = new Object();
    public static final LazyValue<IRecipeType<?>> woodcuttingRecipeType = new LazyValue(() -> (IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation("druidcraft", "woodcutting")));
    public ProcessingInventory inventory = new ProcessingInventory(this::start);
    private int recipeIndex;
    private final LazyOptional<IItemHandler> invProvider;
    private FilteringBehaviour filtering;

    public SawTileEntity(TileEntityType<? extends SawTileEntity> type) {
        super(type);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.invProvider = LazyOptional.of(() -> this.inventory);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour(this, new SawFilterSlot()).forRecipes();
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnelsWhen(this::canProcess));
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compound.func_74768_a("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.recipeIndex = compound.func_74762_e("RecipeIndex");
    }

    @Override
    public void func_73660_a() {
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        super.func_73660_a();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = MathHelper.func_76131_a((float)(Math.abs(this.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles(this.inventory.getStackInSlot(0));
        }
        if (this.field_145850_b.field_72995_K && !this.isVirtual()) {
            return;
        }
        if (this.inventory.remainingTime < 20.0f && !this.inventory.appliedRecipe) {
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.sendData();
            return;
        }
        Vector3d itemMovement = this.getItemMovementVec();
        Direction itemMovementFacing = Direction.func_210769_a((double)itemMovement.field_72450_a, (double)itemMovement.field_72448_b, (double)itemMovement.field_72449_c);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack tryExportingToBeltFunnel;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.func_190926_b() || (tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(stack, itemMovementFacing.func_176734_d(), false)) == null) continue;
            if (tryExportingToBeltFunnel.func_190916_E() != stack.func_190916_E()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.func_190926_b()) continue;
            return;
        }
        BlockPos nextPos = this.field_174879_c.func_177963_a(itemMovement.field_72450_a, itemMovement.field_72448_b, itemMovement.field_72449_c);
        DirectBeltInputBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, nextPos, DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack remainder;
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.func_190926_b() || (remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)).equals(stack, false)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.func_70296_d();
                this.sendData();
            }
            return;
        }
        Vector3d outPos = VecHelper.getCenterOf((Vector3i)this.field_174879_c).func_178787_e(itemMovement.func_186678_a(0.5).func_72441_c(0.0, 0.5, 0.0));
        Vector3d outMotion = itemMovement.func_186678_a(0.0625).func_72441_c(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            ItemEntity entityIn = new ItemEntity(this.field_145850_b, outPos.field_72450_a, outPos.field_72448_b, outPos.field_72449_c, stack);
            entityIn.func_213317_d(outMotion);
            this.field_145850_b.func_217376_c((Entity)entityIn);
        }
        this.inventory.clear();
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    @Override
    public void func_145843_s() {
        this.invProvider.invalidate();
        super.func_145843_s();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != Direction.DOWN) {
            return this.invProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void spawnParticles(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        ItemParticleData particleData = null;
        float speed = 1.0f;
        if (stack.func_77973_b() instanceof BlockItem) {
            particleData = new BlockParticleData(ParticleTypes.field_197611_d, ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P());
        } else {
            particleData = new ItemParticleData(ParticleTypes.field_197591_B, stack);
            speed = 0.125f;
        }
        Random r = this.field_145850_b.field_73012_v;
        Vector3d vec = this.getItemMovementVec();
        Vector3d pos = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        float offset = this.inventory.recipeDuration != 0.0f ? this.inventory.remainingTime / this.inventory.recipeDuration : 0.0f;
        this.field_145850_b.func_195594_a((IParticleData)particleData, pos.func_82615_a() + -vec.field_72450_a * (double)(offset -= 0.5f), pos.func_82617_b() + (double)0.45f, pos.func_82616_c() + -vec.field_72449_c * (double)offset, -vec.field_72450_a * (double)speed, (double)(r.nextFloat() * speed), -vec.field_72449_c * (double)speed);
    }

    public Vector3d getItemMovementVec() {
        boolean alongX = (Boolean)this.func_195044_w().func_177229_b((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new Vector3d((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void applyRecipe() {
        List<IRecipe<?>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        IRecipe<?> recipe = recipes.get(this.recipeIndex);
        int rolls = this.inventory.getStackInSlot(0).func_190916_E();
        this.inventory.clear();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int roll = 0; roll < rolls; ++roll) {
            List<Object> results = new LinkedList();
            if (recipe instanceof CuttingRecipe) {
                results = ((CuttingRecipe)recipe).rollResults();
            } else if (recipe instanceof StonecuttingRecipe || recipe.func_222127_g() == woodcuttingRecipeType.func_179281_c()) {
                results.add(recipe.func_77571_b().func_77946_l());
            }
            for (int i = 0; i < results.size(); ++i) {
                ItemStack stack = (ItemStack)results.get(i);
                ItemHelper.addToList(stack, list);
            }
        }
        for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
            this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
        }
    }

    private List<? extends IRecipe<?>> getRecipes() {
        Predicate<IRecipe<?>> types = RecipeConditions.isOfType(new IRecipeType[]{AllRecipeTypes.CUTTING.getType(), (Boolean)AllConfigs.SERVER.recipes.allowStonecuttingOnSaw.get() != false ? IRecipeType.field_222154_f : null, (Boolean)AllConfigs.SERVER.recipes.allowWoodcuttingOnSaw.get() != false ? (IRecipeType)woodcuttingRecipeType.func_179281_c() : null});
        List<IRecipe<?>> startedSearch = RecipeFinder.get(cuttingRecipesKey, this.field_145850_b, types);
        return startedSearch.stream().filter(RecipeConditions.outputMatchesFilter(this.filtering)).filter(RecipeConditions.firstIngredientMatches(this.inventory.getStackInSlot(0))).collect(Collectors.toList());
    }

    public void insertItem(ItemEntity entity) {
        if (!this.canProcess()) {
            return;
        }
        if (!this.inventory.isEmpty()) {
            return;
        }
        if (!entity.func_70089_S()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.inventory.clear();
        this.inventory.insertItem(0, entity.func_92059_d().func_77946_l(), false);
        entity.func_70106_y();
    }

    public void start(ItemStack inserted) {
        IRecipe<?> recipe;
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.field_145850_b.field_72995_K && !this.isVirtual()) {
            return;
        }
        List<IRecipe<?>> recipes = this.getRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 100;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        if ((recipe = recipes.get(this.recipeIndex)) instanceof CuttingRecipe) {
            time = ((CuttingRecipe)recipe).getProcessingDuration();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.func_190916_E() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    protected boolean canProcess() {
        return this.func_195044_w().func_177229_b((Property)SawBlock.FACING) == Direction.UP;
    }

    @Override
    protected boolean shouldRun() {
        return ((Direction)this.func_195044_w().func_177229_b((Property)SawBlock.FACING)).func_176740_k().func_176722_c();
    }

    @Override
    protected BlockPos getBreakingPos() {
        return this.func_174877_v().func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)SawBlock.FACING));
    }

    @Override
    public void onBlockBroken(BlockState stateToBreak) {
        super.onBlockBroken(stateToBreak);
        TreeCutter.Tree tree = TreeCutter.cutTree((IBlockReader)this.field_145850_b, this.breakingPos);
        if (tree != null) {
            for (BlockPos log : tree.logs) {
                BlockHelper.destroyBlock(this.field_145850_b, log, 0.5f, stack -> this.dropItemFromCutTree(log, (ItemStack)stack));
            }
            for (BlockPos leaf : tree.leaves) {
                BlockHelper.destroyBlock(this.field_145850_b, leaf, 0.125f, stack -> this.dropItemFromCutTree(leaf, (ItemStack)stack));
            }
        }
    }

    public void dropItemFromCutTree(BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.func_177951_i((Vector3i)this.breakingPos));
        Vector3d dropPos = VecHelper.getCenterOf((Vector3i)pos);
        ItemEntity entity = new ItemEntity(this.field_145850_b, dropPos.field_72450_a, dropPos.field_72448_b, dropPos.field_72449_c, stack);
        entity.func_213317_d(Vector3d.func_237491_b_((Vector3i)this.breakingPos.func_177973_b((Vector3i)this.field_174879_c)).func_186678_a((double)(distance / 20.0f)));
        this.field_145850_b.func_217376_c((Entity)entity);
    }

    @Override
    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        boolean sawable = SawTileEntity.isSawable(stateToBreak);
        return super.canBreak(stateToBreak, blockHardness) && sawable;
    }

    public static boolean isSawable(BlockState stateToBreak) {
        if (stateToBreak.func_235714_a_((ITag)BlockTags.field_200031_h) || AllTags.AllBlockTags.SLIMY_LOGS.matches(stateToBreak) || stateToBreak.func_235714_a_((ITag)BlockTags.field_206952_E)) {
            return true;
        }
        Block block = stateToBreak.func_177230_c();
        if (block instanceof BambooBlock) {
            return true;
        }
        if (block instanceof StemGrownBlock) {
            return true;
        }
        if (block instanceof CactusBlock) {
            return true;
        }
        if (block instanceof SugarCaneBlock) {
            return true;
        }
        if (block instanceof KelpBlock) {
            return true;
        }
        if (block instanceof KelpTopBlock) {
            return true;
        }
        return block instanceof ChorusPlantBlock;
    }

    @Override
    public boolean shouldRenderAsTE() {
        return true;
    }
}

