/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.millstone;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.KineticBlock;
import com.simibubi.create.content.contraptions.components.millstone.MillstoneTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MillstoneBlock
extends KineticBlock
implements ITE<MillstoneTileEntity>,
ICogWheel {
    public MillstoneBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.MILLSTONE.create();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.MILLSTONE;
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.DOWN;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_184586_b(handIn).func_190926_b()) {
            return ActionResultType.PASS;
        }
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, millstone -> {
            int slot;
            boolean emptyOutput = true;
            ItemStackHandler inv = millstone.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.func_190926_b()) {
                    emptyOutput = false;
                }
                player.field_71071_by.func_191975_a(worldIn, stackInSlot);
                inv.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            if (emptyOutput) {
                inv = millstone.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    player.field_71071_by.func_191975_a(worldIn, inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.field_190927_a);
                }
            }
            millstone.func_70296_d();
            millstone.sendData();
        });
        return ActionResultType.SUCCESS;
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        if (entityIn.field_70170_p.field_72995_K) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        MillstoneTileEntity millstone = null;
        for (BlockPos pos : Iterate.hereAndBelow(entityIn.func_233580_cy_())) {
            try {
                millstone = (MillstoneTileEntity)this.getTileEntity(worldIn, pos);
            }
            catch (ITE.TileEntityException e) {}
        }
        if (millstone == null) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        LazyOptional capability = millstone.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (!capability.isPresent()) {
            return;
        }
        ItemStack remainder = ((IItemHandler)capability.orElse((Object)new ItemStackHandler())).insertItem(0, itemEntity.func_92059_d(), false);
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        }
        if (remainder.func_190916_E() < itemEntity.func_92059_d().func_190916_E()) {
            itemEntity.func_92058_a(remainder);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.inputInv);
                ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.outputInv);
            });
            worldIn.func_175713_t(pos);
        }
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    @Override
    public Class<MillstoneTileEntity> getTileEntityClass() {
        return MillstoneTileEntity.class;
    }
}

