/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel.engine;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.foundation.render.backend.instancing.IInstanceRendered;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EngineTileEntity
extends SmartTileEntity
implements IInstanceRendered {
    public float appliedCapacity;
    public float appliedSpeed;
    protected FlywheelTileEntity poweredWheel;
    protected AxisAlignedBB cachedBoundingBox;

    public EngineTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.cachedBoundingBox == null) {
            this.cachedBoundingBox = super.getRenderBoundingBox().func_186662_g(1.5);
        }
        return this.cachedBoundingBox;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.poweredWheel != null && this.poweredWheel.func_145837_r()) {
            this.poweredWheel = null;
        }
        if (this.poweredWheel == null) {
            this.attachWheel();
        }
    }

    public void attachWheel() {
        Direction engineFacing = (Direction)this.func_195044_w().func_177229_b((Property)EngineBlock.field_185512_D);
        BlockPos wheelPos = this.field_174879_c.func_177967_a(engineFacing, 2);
        BlockState wheelState = this.field_145850_b.func_180495_p(wheelPos);
        if (!AllBlocks.FLYWHEEL.has(wheelState)) {
            return;
        }
        Direction wheelFacing = (Direction)wheelState.func_177229_b(FlywheelBlock.HORIZONTAL_FACING);
        if (wheelFacing.func_176740_k() != engineFacing.func_176746_e().func_176740_k()) {
            return;
        }
        if (FlywheelBlock.isConnected(wheelState) && FlywheelBlock.getConnection(wheelState) != engineFacing.func_176734_d()) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(wheelPos);
        if (te.func_145837_r()) {
            return;
        }
        if (te instanceof FlywheelTileEntity) {
            if (!FlywheelBlock.isConnected(wheelState)) {
                FlywheelBlock.setConnection(this.field_145850_b, te.func_174877_v(), te.func_195044_w(), engineFacing.func_176734_d());
            }
            this.poweredWheel = (FlywheelTileEntity)te;
            this.refreshWheelSpeed();
        }
    }

    public void detachWheel() {
        if (this.poweredWheel == null || this.poweredWheel.func_145837_r()) {
            return;
        }
        this.poweredWheel.setRotation(0.0f, 0.0f);
        FlywheelBlock.setConnection(this.field_145850_b, this.poweredWheel.func_174877_v(), this.poweredWheel.func_195044_w(), null);
        this.poweredWheel = null;
    }

    @Override
    public void func_145843_s() {
        this.detachWheel();
        super.func_145843_s();
    }

    protected void refreshWheelSpeed() {
        if (this.poweredWheel == null) {
            return;
        }
        this.poweredWheel.setRotation(this.appliedSpeed, this.appliedCapacity);
    }
}

