/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel;

import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;

public class FlywheelTileEntity
extends GeneratingKineticTileEntity {
    private float generatedCapacity;
    private float generatedSpeed;
    private int stoppingCooldown;
    InterpolatedChasingValue visualSpeed = new InterpolatedChasingValue();
    float angle;

    public FlywheelTileEntity(TileEntityType<? extends FlywheelTileEntity> type) {
        super(type);
    }

    public void setRotation(float speed, float capacity) {
        if (this.generatedSpeed != speed || this.generatedCapacity != capacity) {
            if (speed == 0.0f) {
                if (this.stoppingCooldown == 0) {
                    this.stoppingCooldown = 40;
                }
                return;
            }
            this.stoppingCooldown = 0;
            this.generatedSpeed = speed;
            this.generatedCapacity = capacity;
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        return FlywheelTileEntity.convertToDirection(this.generatedSpeed, (Direction)this.func_195044_w().func_177229_b(FlywheelBlock.HORIZONTAL_FACING));
    }

    @Override
    public float calculateAddedStressCapacity() {
        return this.generatedCapacity;
    }

    @Override
    public AxisAlignedBB makeRenderBoundingBox() {
        return super.makeRenderBoundingBox().func_186662_g(2.0);
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74776_a("GeneratedSpeed", this.generatedSpeed);
        compound.func_74776_a("GeneratedCapacity", this.generatedCapacity);
        compound.func_74768_a("Cooldown", this.stoppingCooldown);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.generatedSpeed = compound.func_74760_g("GeneratedSpeed");
        this.generatedCapacity = compound.func_74760_g("GeneratedCapacity");
        this.stoppingCooldown = compound.func_74762_e("Cooldown");
        super.fromTag(state, compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.withSpeed(0.03125f).target(this.getGeneratedSpeed());
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            float targetSpeed = this.isVirtual() ? this.speed : this.getGeneratedSpeed();
            this.visualSpeed.target(targetSpeed);
            this.visualSpeed.tick();
            this.angle += this.visualSpeed.value * 3.0f / 10.0f;
            this.angle %= 360.0f;
            return;
        }
        if (this.getGeneratedSpeed() != 0.0f && this.getSpeed() == 0.0f) {
            this.updateGeneratedRotation();
        }
        if (this.stoppingCooldown == 0) {
            return;
        }
        --this.stoppingCooldown;
        if (this.stoppingCooldown == 0) {
            this.generatedCapacity = 0.0f;
            this.generatedSpeed = 0.0f;
            this.updateGeneratedRotation();
        }
    }
}

