/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.RotatingData;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstanceData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.render.backend.instancing.RenderMaterial;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import java.util.Collections;
import java.util.List;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class FlyWheelInstance
extends KineticTileInstance<FlywheelTileEntity>
implements IDynamicInstance {
    protected final Direction facing;
    protected final Direction connection;
    protected boolean connectedLeft;
    protected float connectorAngleMult;
    protected final RotatingData shaft;
    protected final ModelData wheel;
    protected List<ModelData> connectors;
    protected ModelData upperRotating;
    protected ModelData lowerRotating;
    protected ModelData upperSliding;
    protected ModelData lowerSliding;
    protected float lastAngle = Float.NaN;

    public FlyWheelInstance(InstancedTileRenderer<?> modelManager, FlywheelTileEntity tile) {
        super(modelManager, tile);
        this.facing = (Direction)this.blockState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        this.shaft = this.setup(this.shaftModel().createInstance());
        this.wheel = AllBlockPartials.FLYWHEEL.renderOnHorizontalModel(modelManager, this.blockState.func_185907_a(Rotation.CLOCKWISE_90)).createInstance();
        this.connection = FlywheelBlock.getConnection(this.blockState);
        if (this.connection != null) {
            this.connectedLeft = this.blockState.func_177229_b(FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
            boolean flipAngle = this.connection.func_176740_k() == Direction.Axis.X ^ this.connection.func_176743_c() == Direction.AxisDirection.NEGATIVE;
            this.connectorAngleMult = flipAngle ? -1.0f : 1.0f;
            RenderMaterial<?, InstancedModel<ModelData>> mat = this.getTransformMaterial();
            this.upperRotating = mat.getModel(AllBlockPartials.FLYWHEEL_UPPER_ROTATING, this.blockState).createInstance();
            this.lowerRotating = mat.getModel(AllBlockPartials.FLYWHEEL_LOWER_ROTATING, this.blockState).createInstance();
            this.upperSliding = mat.getModel(AllBlockPartials.FLYWHEEL_UPPER_SLIDING, this.blockState).createInstance();
            this.lowerSliding = mat.getModel(AllBlockPartials.FLYWHEEL_LOWER_SLIDING, this.blockState).createInstance();
            this.connectors = Lists.newArrayList((Object[])new ModelData[]{this.upperRotating, this.lowerRotating, this.upperSliding, this.lowerSliding});
        } else {
            this.connectors = Collections.emptyList();
        }
        this.animate(tile.angle);
    }

    @Override
    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float speed = ((FlywheelTileEntity)this.tile).visualSpeed.get(partialTicks) * 3.0f / 10.0f;
        float angle = ((FlywheelTileEntity)this.tile).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        MatrixStack ms = new MatrixStack();
        MatrixStacker msr = MatrixStacker.of(ms);
        msr.translate((Vector3i)this.getInstancePosition());
        if (this.connection != null) {
            float rotation = angle * this.connectorAngleMult;
            ms.func_227860_a_();
            this.rotateToFacing(msr, this.connection);
            ms.func_227860_a_();
            this.transformConnector(msr, true, true, rotation, this.connectedLeft);
            this.upperRotating.setTransform(ms);
            ms.func_227865_b_();
            ms.func_227860_a_();
            this.transformConnector(msr, false, true, rotation, this.connectedLeft);
            this.lowerRotating.setTransform(ms);
            ms.func_227865_b_();
            ms.func_227860_a_();
            this.transformConnector(msr, true, false, rotation, this.connectedLeft);
            this.upperSliding.setTransform(ms);
            ms.func_227865_b_();
            ms.func_227860_a_();
            this.transformConnector(msr, false, false, rotation, this.connectedLeft);
            this.lowerSliding.setTransform(ms);
            ms.func_227865_b_();
            ms.func_227865_b_();
        }
        msr.centre().rotate(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.facing.func_176740_k()), AngleHelper.rad(angle)).unCentre();
        this.wheel.setTransform(ms);
    }

    @Override
    protected void update() {
        this.updateRotation(this.shaft);
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, this.shaft, this.wheel);
        if (this.connection != null) {
            this.relight(this.pos.func_177972_a(this.connection), this.connectors.stream());
        }
    }

    @Override
    public void remove() {
        this.shaft.delete();
        this.wheel.delete();
        this.connectors.forEach(InstanceData::delete);
        this.connectors.clear();
    }

    protected InstancedModel<RotatingData> shaftModel() {
        return AllBlockPartials.SHAFT_HALF.renderOnDirectionalSouthRotating(this.renderer, this.blockState, this.facing.func_176734_d());
    }

    protected void transformConnector(MatrixStacker ms, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = MathHelper.func_76126_a((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        ms.translate(pivotX, pivotY, pivotZ + shifting);
        if (rotating) {
            ms.rotate(Direction.EAST, AngleHelper.rad(barAngle));
        }
        ms.translate(-pivotX, -pivotY, -pivotZ);
        if (flip && !upper) {
            ms.translate(0.5625, 0.0, 0.0);
        }
    }

    protected void rotateToFacing(MatrixStacker buffer, Direction facing) {
        buffer.centre().rotate(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing))).unCentre();
    }
}

