/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.RotatingData;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanTileEntity;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class FanInstance
extends KineticTileInstance<EncasedFanTileEntity> {
    protected final RotatingData shaft;
    protected final RotatingData fan;
    final Direction direction;

    public FanInstance(InstancedTileRenderer<?> modelManager, EncasedFanTileEntity tile) {
        super(modelManager, tile);
        this.direction = (Direction)this.blockState.func_177229_b((Property)BlockStateProperties.field_208155_H);
        this.shaft = AllBlockPartials.SHAFT_HALF.renderOnDirectionalSouthRotating(modelManager, this.blockState, this.direction.func_176734_d()).createInstance();
        this.fan = AllBlockPartials.ENCASED_FAN_INNER.renderOnDirectionalSouthRotating(modelManager, this.blockState, this.direction.func_176734_d()).createInstance();
        this.setup(this.shaft);
        this.setup(this.fan, this.getFanSpeed());
    }

    private float getFanSpeed() {
        float speed = ((EncasedFanTileEntity)this.tile).getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = MathHelper.func_76131_a((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = MathHelper.func_76131_a((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        return speed;
    }

    @Override
    protected void update() {
        this.updateRotation(this.shaft);
        this.updateRotation(this.fan, this.getFanSpeed());
    }

    @Override
    public void updateLight() {
        BlockPos behind = this.pos.func_177972_a(this.direction.func_176734_d());
        this.relight(behind, this.shaft);
        BlockPos inFront = this.pos.func_177972_a(this.direction);
        this.relight(inFront, this.fan);
    }

    @Override
    public void remove() {
        this.shaft.delete();
        this.fan.delete();
    }
}

