/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanBlock;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
public class EncasedFanTileEntity
extends GeneratingKineticTileEntity
implements IAirCurrentSource {
    public AirCurrent airCurrent = new AirCurrent(this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean isGenerator = false;
    protected boolean updateAirFlow = true;
    protected boolean updateGenerator = false;

    public EncasedFanTileEntity(TileEntityType<? extends EncasedFanTileEntity> type) {
        super(type);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        if (!this.wasMoved) {
            this.isGenerator = compound.func_74767_n("Generating");
        }
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("Generating", this.isGenerator);
        super.write(compound, clientPacket);
    }

    @Override
    public float calculateAddedStressCapacity() {
        return this.isGenerator ? super.calculateAddedStressCapacity() : 0.0f;
    }

    @Override
    public float calculateStressApplied() {
        return this.isGenerator ? 0.0f : super.calculateStressApplied();
    }

    @Override
    public float getGeneratedSpeed() {
        return this.isGenerator ? (float)((Integer)AllConfigs.SERVER.kinetics.generatingFanSpeed.get()).intValue() : 0.0f;
    }

    public void queueGeneratorUpdate() {
        this.updateGenerator = true;
    }

    public void updateGenerator() {
        BlockState blockState = this.func_195044_w();
        boolean shouldGenerate = true;
        if (!AllBlocks.ENCASED_FAN.has(blockState)) {
            shouldGenerate = false;
        }
        if (shouldGenerate && blockState.func_177229_b((Property)EncasedFanBlock.FACING) != Direction.DOWN) {
            shouldGenerate = false;
        }
        if (shouldGenerate) {
            boolean bl = shouldGenerate = this.field_145850_b != null && this.field_145850_b.func_175640_z(this.field_174879_c) && this.field_145850_b.func_195588_v(this.field_174879_c.func_177977_b()) && this.blockBelowIsHot();
        }
        if (shouldGenerate == this.isGenerator) {
            return;
        }
        this.isGenerator = shouldGenerate;
        this.updateGeneratedRotation();
    }

    public boolean blockBelowIsHot() {
        if (this.field_145850_b == null) {
            return false;
        }
        BlockState checkState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (!checkState.func_177230_c().func_203417_a(AllTags.AllBlockTags.FAN_HEATERS.tag)) {
            return false;
        }
        if (checkState.func_235901_b_(BlazeBurnerBlock.HEAT_LEVEL) && !((BlazeBurnerBlock.HeatLevel)((Object)checkState.func_177229_b(BlazeBurnerBlock.HEAT_LEVEL))).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            return false;
        }
        return !checkState.func_235901_b_((Property)BlockStateProperties.field_208190_q) || (Boolean)checkState.func_177229_b((Property)BlockStateProperties.field_208190_q) != false;
    }

    @Override
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Override
    @Nullable
    public World getAirCurrentWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getAirCurrentPos() {
        return this.field_174879_c;
    }

    @Override
    public Direction getAirflowOriginSide() {
        return (Direction)this.func_195044_w().func_177229_b((Property)EncasedFanBlock.FACING);
    }

    @Override
    public Direction getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        return (speed = EncasedFanTileEntity.convertToDirection(speed, facing)) > 0.0f ? facing : facing.func_176734_d();
    }

    @Override
    public boolean isSourceRemoved() {
        return this.field_145846_f;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void updateChute() {
        Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)EncasedFanBlock.FACING);
        if (!direction.func_176740_k().func_200128_b()) {
            return;
        }
        TileEntity poweredChute = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
        if (!(poweredChute instanceof ChuteTileEntity)) {
            return;
        }
        ChuteTileEntity chuteTE = (ChuteTileEntity)poweredChute;
        if (direction == Direction.DOWN) {
            chuteTE.updatePull();
        } else {
            chuteTE.updatePush(1);
        }
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    @Override
    public void func_73660_a() {
        boolean server;
        super.func_73660_a();
        boolean bl = server = !this.field_145850_b.field_72995_K || this.isVirtual();
        if (server && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.SERVER.kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            this.sendData();
        }
        if (this.updateGenerator) {
            this.updateGenerator = false;
            this.updateGenerator();
        }
        if (this.getSpeed() == 0.0f || this.isGenerator) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        this.airCurrent.tick();
    }
}

