/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.components.actors.SeatEntity;
import com.simibubi.create.foundation.utility.DyeHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SeatBlock
extends Block {
    private final boolean inCreativeTab;

    public SeatBlock(AbstractBlock.Properties p_i48440_1_, boolean inCreativeTab) {
        super(p_i48440_1_);
        this.inCreativeTab = inCreativeTab;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> p_149666_2_) {
        if (group != ItemGroup.field_78027_g && !this.inCreativeTab) {
            return;
        }
        super.func_149666_a(group, p_149666_2_);
    }

    public void func_180658_a(World p_180658_1_, BlockPos p_180658_2_, Entity p_180658_3_, float p_180658_4_) {
        super.func_180658_a(p_180658_1_, p_180658_2_, p_180658_3_, p_180658_4_ * 0.5f);
    }

    public void func_176216_a(IBlockReader reader, Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        if (entity instanceof PlayerEntity || !(entity instanceof LivingEntity) || !SeatBlock.canBePickedUp(entity) || SeatBlock.isSeatOccupied(entity.field_70170_p, pos)) {
            Blocks.field_196594_as.func_176216_a(reader, entity);
            return;
        }
        if (reader.func_180495_p(pos).func_177230_c() != this) {
            return;
        }
        SeatBlock.sitDown(entity.field_70170_p, pos, entity);
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.RAIL;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.SEAT;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return AllShapes.SEAT_COLLISION;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        for (DyeColor color : DyeColor.values()) {
            if (!heldItem.func_77973_b().func_206844_a(DyeHelper.getTagOfDye(color))) continue;
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockState newState = AllBlocks.SEATS[color.ordinal()].getDefaultState();
            if (newState != state) {
                world.func_175656_a(pos, newState);
            }
            return ActionResultType.SUCCESS;
        }
        List seats = world.func_217357_a(SeatEntity.class, new AxisAlignedBB(pos));
        if (!seats.isEmpty()) {
            SeatEntity seatEntity = (SeatEntity)((Object)seats.get(0));
            List passengers = seatEntity.func_184188_bt();
            if (!passengers.isEmpty() && passengers.get(0) instanceof PlayerEntity) {
                return ActionResultType.PASS;
            }
            if (!world.field_72995_K) {
                seatEntity.func_184226_ay();
                player.func_184220_m((Entity)seatEntity);
            }
            return ActionResultType.SUCCESS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        SeatBlock.sitDown(world, pos, (Entity)player);
        return ActionResultType.SUCCESS;
    }

    public static boolean isSeatOccupied(World world, BlockPos pos) {
        return !world.func_217357_a(SeatEntity.class, new AxisAlignedBB(pos)).isEmpty();
    }

    public static boolean canBePickedUp(Entity passenger) {
        return !(passenger instanceof PlayerEntity) && passenger instanceof LivingEntity;
    }

    public static void sitDown(World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        SeatEntity seat = new SeatEntity(world, pos);
        seat.func_226288_n_((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        world.func_217376_c((Entity)seat);
        entity.func_184205_a((Entity)seat, true);
    }
}

