/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.components.actors.BlockBreakingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.actors.DrillTileEntity;
import com.simibubi.create.foundation.block.ITE;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DrillBlock
extends DirectionalKineticBlock
implements ITE<DrillTileEntity> {
    public static DamageSource damageSourceDrill = new DamageSource("create.mechanical_drill").func_76348_h();

    public DrillBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            return;
        }
        if (!new AxisAlignedBB(pos).func_186664_h((double)0.1f).func_72326_a(entityIn.func_174813_aQ())) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            if (te.getSpeed() == 0.0f) {
                return;
            }
            entityIn.func_70097_a(damageSourceDrill, (float)DrillBlock.getDamage(te.getSpeed()));
        });
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.DRILL.create();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.CASING_12PX.get((Direction)state.func_177229_b((Property)FACING));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.withTileEntityDo((IBlockReader)worldIn, pos, BlockBreakingKineticTileEntity::destroyNextTick);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k();
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    @Override
    public Class<DrillTileEntity> getTileEntityClass() {
        return DrillTileEntity.class;
    }

    public static double getDamage(float speed) {
        float speedAbs = Math.abs(speed);
        double sub1 = Math.min(speedAbs / 16.0f, 2.0f);
        double sub2 = Math.min(speedAbs / 32.0f, 4.0f);
        double sub3 = Math.min(speedAbs / 64.0f, 4.0f);
        return MathHelper.func_151237_a((double)(sub1 + sub2 + sub3), (double)1.0, (double)10.0);
    }
}

