/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.foundation.render.backend.instancing.InstanceData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import java.nio.ByteBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class ActorData
extends InstanceData {
    private float x;
    private float y;
    private float z;
    private byte blockLight;
    private byte skyLight;
    private float rotationOffset;
    private byte rotationAxisX;
    private byte rotationAxisY;
    private byte rotationAxisZ;
    private float qX;
    private float qY;
    private float qZ;
    private float qW;
    private byte rotationCenterX = (byte)64;
    private byte rotationCenterY = (byte)64;
    private byte rotationCenterZ = (byte)64;
    private float speed;

    protected ActorData(InstancedModel<?> owner) {
        super(owner);
    }

    public ActorData setPosition(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.markDirty();
        return this;
    }

    public ActorData setBlockLight(int blockLight) {
        this.blockLight = (byte)((blockLight & 0xF) << 4);
        this.markDirty();
        return this;
    }

    public ActorData setSkyLight(int skyLight) {
        this.skyLight = (byte)((skyLight & 0xF) << 4);
        this.markDirty();
        return this;
    }

    public ActorData setRotationOffset(float rotationOffset) {
        this.rotationOffset = rotationOffset;
        this.markDirty();
        return this;
    }

    public ActorData setSpeed(float speed) {
        this.speed = speed;
        this.markDirty();
        return this;
    }

    public ActorData setRotationAxis(Vector3f axis) {
        this.setRotationAxis(axis.func_195899_a(), axis.func_195900_b(), axis.func_195902_c());
        return this;
    }

    public ActorData setRotationAxis(float rotationAxisX, float rotationAxisY, float rotationAxisZ) {
        this.rotationAxisX = (byte)(rotationAxisX * 127.0f);
        this.rotationAxisY = (byte)(rotationAxisY * 127.0f);
        this.rotationAxisZ = (byte)(rotationAxisZ * 127.0f);
        this.markDirty();
        return this;
    }

    public ActorData setRotationCenter(Vector3f axis) {
        this.setRotationCenter(axis.func_195899_a(), axis.func_195900_b(), axis.func_195902_c());
        return this;
    }

    public ActorData setRotationCenter(float rotationCenterX, float rotationCenterY, float rotationCenterZ) {
        this.rotationCenterX = (byte)(rotationCenterX * 127.0f);
        this.rotationCenterY = (byte)(rotationCenterY * 127.0f);
        this.rotationCenterZ = (byte)(rotationCenterZ * 127.0f);
        this.markDirty();
        return this;
    }

    public ActorData setLocalRotation(Quaternion q) {
        this.qX = q.func_195889_a();
        this.qY = q.func_195891_b();
        this.qZ = q.func_195893_c();
        this.qW = q.func_195894_d();
        this.markDirty();
        return this;
    }

    @Override
    public void write(ByteBuffer buf) {
        this.putVec3(buf, this.x, this.y, this.z);
        this.putVec2(buf, this.blockLight, this.skyLight);
        this.put(buf, this.rotationOffset);
        this.putVec3(buf, this.rotationAxisX, this.rotationAxisY, this.rotationAxisZ);
        this.putVec4(buf, this.qX, this.qY, this.qZ, this.qW);
        this.putVec3(buf, this.rotationCenterX, this.rotationCenterY, this.rotationCenterZ);
        this.put(buf, this.speed);
    }
}

