/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.Lang;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum AllSoundEvents implements IDataProvider
{
    CUCKOO_PIG("pigclock"),
    CUCKOO_CREEPER("creeperclock"),
    SCHEMATICANNON_LAUNCH_BLOCK(SoundEvents.field_187539_bB),
    SCHEMATICANNON_FINISH(SoundEvents.field_193807_ew),
    SLIME_ADDED(SoundEvents.field_187884_fr),
    MECHANICAL_PRESS_ACTIVATION(SoundEvents.field_187689_f),
    MECHANICAL_PRESS_ITEM_BREAK(SoundEvents.field_187635_cQ),
    BLOCKZAPPER_PLACE(SoundEvents.field_187676_dE),
    BLOCKZAPPER_CONFIRM(SoundEvents.field_193807_ew),
    BLOCKZAPPER_DENY(SoundEvents.field_187679_dF),
    BLOCK_FUNNEL_EAT(SoundEvents.field_187537_bA),
    BLAZE_MUNCH(SoundEvents.field_187537_bA);

    String id;
    SoundEvent event;
    SoundEvent child;
    private DataGenerator generator;

    private AllSoundEvents() {
        this.id = Lang.asId(this.name());
    }

    private AllSoundEvents(String name) {
        this.id = name;
    }

    private AllSoundEvents(SoundEvent child) {
        this();
        this.child = child;
    }

    public SoundEvent get() {
        return this.event;
    }

    private String getEventName() {
        return this.id;
    }

    public AllSoundEvents generator(DataGenerator generator) {
        this.generator = generator;
        return this;
    }

    public static void register(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        for (AllSoundEvents entry : AllSoundEvents.values()) {
            ResourceLocation rec = new ResourceLocation("create", entry.getEventName());
            SoundEvent sound = (SoundEvent)new SoundEvent(rec).setRegistryName(rec);
            registry.register((IForgeRegistryEntry)sound);
            entry.event = sound;
        }
    }

    public void generate(Path path, DirectoryCache cache) {
        Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        path = path.resolve("assets/create");
        try {
            JsonObject json = new JsonObject();
            for (AllSoundEvents soundEvent : AllSoundEvents.values()) {
                JsonObject entry = new JsonObject();
                JsonArray arr = new JsonArray();
                if (soundEvent.child != null) {
                    JsonObject s = new JsonObject();
                    s.addProperty("name", soundEvent.child.func_187503_a().toString());
                    s.addProperty("type", "event");
                    arr.add((JsonElement)s);
                } else {
                    arr.add("create:" + soundEvent.getEventName());
                }
                entry.add("sounds", (JsonElement)arr);
                entry.addProperty("subtitle", "create.subtitle." + soundEvent.getEventName());
                json.add(soundEvent.getEventName(), (JsonElement)entry);
            }
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.generate(this.generator.func_200391_b(), cache);
    }

    public String func_200397_b() {
        return "Create's Custom Sound: " + this.name();
    }
}

