/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.gui;

import com.hrznstudio.emojiful.ClientProxy;
import com.hrznstudio.emojiful.Emojiful;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.api.EmojiCategory;
import com.hrznstudio.emojiful.gui.IDrawableGuiListener;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModList;

public class EmojiSelectionGui
implements IDrawableGuiListener {
    private int selectionPointer = 1;
    private int categoryPointer = 0;
    private ChatScreen chatScreen;
    private int openSelectionAreaEmoji;
    private boolean showingSelectionArea;
    private TextFieldWidget fieldWidget;
    private Rectangle2d openSelectionArea;
    private Rectangle2d selectionArea;
    private Rectangle2d categorySelectionArea;
    private Rectangle2d emojiInfoArea;
    private Rectangle2d textFieldRectangle;
    private double lastMouseX;
    private double lastMouseY;
    private Emoji lastEmoji;
    private List<Emoji[]> filteredEmojis;

    public EmojiSelectionGui(ChatScreen screen) {
        this.chatScreen = screen;
        this.openSelectionAreaEmoji = -1;
        if (Emojiful.EMOJI_MAP.containsKey("Smileys & Emotion")) {
            this.openSelectionAreaEmoji = new Random().nextInt(Emojiful.EMOJI_MAP.get("Smileys & Emotion").size());
        }
        this.showingSelectionArea = false;
        int offset = 0;
        if (ModList.get().isLoaded("quark")) {
            offset = -80;
        }
        this.openSelectionArea = new Rectangle2d(this.chatScreen.field_230708_k_ - 14, this.chatScreen.field_230709_l_ - 12, 12, 12);
        this.selectionArea = new Rectangle2d(this.chatScreen.field_230708_k_ - 14 - 132 + offset, this.chatScreen.field_230709_l_ - 16 - 110 - 4, 136, 114);
        this.categorySelectionArea = new Rectangle2d(this.selectionArea.func_199318_a(), this.selectionArea.func_199319_b() + 20, 22, this.selectionArea.func_199317_d() - 20);
        this.emojiInfoArea = new Rectangle2d(this.selectionArea.func_199318_a() + 22, this.selectionArea.func_199319_b() + this.selectionArea.func_199317_d() - 20, this.selectionArea.func_199316_c() - 22, 20);
        this.textFieldRectangle = new Rectangle2d(this.selectionArea.func_199318_a() + 6, this.selectionArea.func_199319_b() + 6, this.selectionArea.func_199316_c() - 12, 10);
        this.fieldWidget = new TextFieldWidget(ClientProxy.oldFontRenderer, this.textFieldRectangle.func_199318_a(), this.textFieldRectangle.func_199319_b(), this.textFieldRectangle.func_199316_c(), this.textFieldRectangle.func_199317_d(), (ITextComponent)new StringTextComponent(""));
        this.fieldWidget.func_146184_c(true);
        this.fieldWidget.func_146189_e(true);
        this.filteredEmojis = new ArrayList<Emoji[]>();
    }

    @Override
    public void render(MatrixStack stack) {
        if (this.openSelectionAreaEmoji != -1) {
            Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, Emojiful.EMOJI_MAP.get((Object)"Smileys & Emotion").get((int)this.openSelectionAreaEmoji).strings.get(0), (float)this.openSelectionArea.func_199318_a(), (float)this.openSelectionArea.func_199319_b(), 0);
        }
        if (this.showingSelectionArea) {
            this.drawRectangle(stack, this.selectionArea);
            this.drawRectangle(stack, this.categorySelectionArea);
            this.drawRectangle(stack, this.emojiInfoArea);
            for (int i = 0; i < 6; ++i) {
                this.drawLine(stack, (float)i * 12.0f, i + this.selectionPointer);
            }
            int progressY = (int)((double)(this.emojiInfoArea.func_199319_b() - this.categorySelectionArea.func_199319_b() - 5) / (double)this.getLineAmount() * (double)this.selectionPointer);
            this.drawRectangle(stack, new Rectangle2d(this.selectionArea.func_199318_a() + this.selectionArea.func_199316_c() - 2, this.categorySelectionArea.func_199319_b() + progressY, 1, 5), -11382190);
            if (this.lastEmoji != null) {
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, this.lastEmoji.strings.get(0), (float)(this.emojiInfoArea.func_199318_a() + 2), (float)(this.emojiInfoArea.func_199319_b() + 6), 0);
                StringBuilder builder = new StringBuilder();
                this.lastEmoji.strings.forEach(s -> builder.append((String)s).append(" "));
                float textScale = 0.5f;
                List iTextPropertiesList = ClientProxy.oldFontRenderer.func_238425_b_((ITextProperties)new StringTextComponent(builder.toString()), (int)((float)(this.emojiInfoArea.func_199316_c() - 18) * (1.0f / textScale)));
                float i = -iTextPropertiesList.size() / 2;
                stack.func_227860_a_();
                stack.func_227862_a_(textScale, textScale, textScale);
                for (IReorderingProcessor reorderingProcessor : iTextPropertiesList) {
                    StringBuilder stringBuilder = new StringBuilder();
                    reorderingProcessor.accept((p_accept_1_, p_accept_2_, ch) -> {
                        stringBuilder.append((char)ch);
                        return true;
                    });
                    ClientProxy.oldFontRenderer.func_238421_b_(stack, stringBuilder.toString(), (float)(this.emojiInfoArea.func_199318_a() + 15) * (1.0f / textScale), ((float)(this.emojiInfoArea.func_199319_b() + 8) + 4.0f * i) * (1.0f / textScale), 0x969696);
                    i += 1.0f;
                }
                stack.func_227862_a_(1.0f, 1.0f, 1.0f);
                stack.func_227865_b_();
            }
            progressY = (int)((double)(this.categorySelectionArea.func_199317_d() - 10) / ((double)ClientProxy.CATEGORIES.size() - 7.0) * (double)this.categoryPointer);
            this.drawRectangle(stack, new Rectangle2d(this.categorySelectionArea.func_199318_a() + this.categorySelectionArea.func_199316_c() - 2, this.categorySelectionArea.func_199319_b() + progressY + 2, 1, 5), -11382190);
            EmojiCategory firstCategory = this.getCategory(this.selectionPointer);
            for (int i = 0; i < 7; ++i) {
                int selCategory = i + this.categoryPointer;
                if (selCategory >= ClientProxy.CATEGORIES.size()) continue;
                EmojiCategory category = ClientProxy.CATEGORIES.get(selCategory);
                Rectangle2d rec = new Rectangle2d(this.categorySelectionArea.func_199318_a() + 6, this.categorySelectionArea.func_199319_b() + 6 + i * 12, 11, 11);
                if (category.equals(firstCategory)) {
                    AbstractGui.func_238467_a_((MatrixStack)stack, (int)(rec.func_199318_a() - 1), (int)(rec.func_199319_b() - 2), (int)(rec.func_199318_a() + rec.func_199316_c()), (int)(rec.func_199319_b() + rec.func_199317_d() - 1), (int)-2130706433);
                }
                if (rec.func_199315_b((int)this.lastMouseX, (int)this.lastMouseY) && Minecraft.func_71410_x().field_71462_r != null) {
                    Minecraft.func_71410_x().field_71462_r.func_243308_b(stack, Arrays.asList(new StringTextComponent(category.getName())), (int)this.lastMouseX, (int)this.lastMouseY);
                }
                if (!ClientProxy.SORTED_EMOJIS_FOR_SELECTION.containsKey(category) || ClientProxy.SORTED_EMOJIS_FOR_SELECTION.get(category).size() <= 0) continue;
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, ClientProxy.SORTED_EMOJIS_FOR_SELECTION.get((Object)category).get((int)0)[0].strings.get(0), (float)(this.categorySelectionArea.func_199318_a() + 6), (float)(this.categorySelectionArea.func_199319_b() + 6 + i * 12), 0);
            }
            this.fieldWidget.func_230430_a_(stack, (int)this.lastMouseX, (int)this.lastMouseY, 0.0f);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int p_231044_5_) {
        if (this.showingSelectionArea) {
            if (this.textFieldRectangle.func_199315_b((int)mouseX, (int)mouseY)) {
                this.fieldWidget.func_146195_b(true);
            } else {
                this.fieldWidget.func_146195_b(false);
            }
            if (this.categorySelectionArea.func_199315_b((int)mouseX, (int)mouseY)) {
                for (int i = 0; i < 7; ++i) {
                    Rectangle2d rec;
                    int selCategory = i + this.categoryPointer;
                    if (selCategory >= ClientProxy.CATEGORIES.size() || !(rec = new Rectangle2d(this.categorySelectionArea.func_199318_a() + 6, this.categorySelectionArea.func_199319_b() + 6 + i * 12, 11, 11)).func_199315_b((int)mouseX, (int)mouseY)) continue;
                    EmojiCategory name = ClientProxy.CATEGORIES.get(selCategory);
                    for (int i1 = 0; i1 < this.getLineAmount(); ++i1) {
                        if (!name.equals(this.getLineToDraw(i1))) continue;
                        this.selectionPointer = i1;
                    }
                }
                return true;
            }
            if (this.selectionArea.func_199315_b((int)mouseX, (int)mouseY)) {
                for (int line = 0; line < 6; ++line) {
                    Object object = this.getLineToDraw(line + this.selectionPointer);
                    if (!(object instanceof Emoji[])) continue;
                    Emoji[] emojis = (Emoji[])object;
                    for (int i = 0; i < emojis.length; ++i) {
                        float y;
                        float x;
                        Rectangle2d rec;
                        if (emojis[i] == null || !(rec = new Rectangle2d((int)(x = (float)(this.categorySelectionArea.func_199318_a() + this.categorySelectionArea.func_199316_c() + 2) + 12.0f * (float)i), (int)(y = (float)(this.categorySelectionArea.func_199319_b() + line * 12 + 2)) - 1, 11, 11)).func_199315_b((int)this.lastMouseX, (int)this.lastMouseY)) continue;
                        this.chatScreen.field_146415_a.func_146180_a(this.chatScreen.field_146415_a.func_146179_b() + emojis[i].getShorterString());
                    }
                }
                return true;
            }
        } else if (this.openSelectionArea.func_199315_b((int)mouseX, (int)mouseY)) {
            this.showSelectionArea();
            return true;
        }
        return false;
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.categorySelectionArea.func_199315_b((int)mouseX, (int)mouseY)) {
            this.categoryPointer = (int)((double)this.categoryPointer - delta);
            this.categoryPointer = MathHelper.func_76125_a((int)this.categoryPointer, (int)0, (int)(ClientProxy.CATEGORIES.size() - 7));
            return true;
        }
        if (this.selectionArea.func_199315_b((int)mouseX, (int)mouseY)) {
            this.selectionPointer = (int)((double)this.selectionPointer - delta);
            this.selectionPointer = MathHelper.func_76125_a((int)this.selectionPointer, (int)1, (int)Math.max(1, this.getLineAmount() - 5));
            this.categoryPointer = MathHelper.func_76125_a((int)Arrays.asList(ClientProxy.CATEGORIES).indexOf(this.getCategory(this.selectionPointer)), (int)0, (int)(ClientProxy.CATEGORIES.size() - 7));
            return true;
        }
        return false;
    }

    public void drawRectangle(MatrixStack stack, Rectangle2d rectangle2d) {
        this.drawRectangle(stack, rectangle2d, Integer.MIN_VALUE);
    }

    public void drawRectangle(MatrixStack stack, Rectangle2d rectangle2d, int value) {
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)rectangle2d.func_199318_a(), (int)rectangle2d.func_199319_b(), (int)(rectangle2d.func_199318_a() + rectangle2d.func_199316_c()), (int)(rectangle2d.func_199319_b() + rectangle2d.func_199317_d()), (int)value);
    }

    public void showSelectionArea() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        this.showingSelectionArea = !this.showingSelectionArea;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.fieldWidget.func_231046_a_(keyCode, scanCode, modifiers)) {
            this.updateFilter();
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char c, int mod) {
        if (this.fieldWidget.func_231042_a_(c, mod)) {
            this.updateFilter();
            return true;
        }
        return false;
    }

    public void drawLine(MatrixStack stack, float height, int line) {
        Object lineToDraw = this.getLineToDraw(line);
        if (lineToDraw != null) {
            if (lineToDraw instanceof EmojiCategory) {
                float textScale = 1.0f;
                RenderSystem.scaled((double)textScale, (double)textScale, (double)textScale);
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, ((EmojiCategory)lineToDraw).getName(), (float)(this.categorySelectionArea.func_199318_a() + this.categorySelectionArea.func_199316_c() + 2) * (1.0f / textScale), ((float)this.categorySelectionArea.func_199319_b() + height + 2.0f) * (1.0f / textScale), 0x969696);
                RenderSystem.scaled((double)1.0, (double)1.0, (double)1.0);
            } else {
                Emoji[] emojis = (Emoji[])lineToDraw;
                for (int i = 0; i < emojis.length; ++i) {
                    float y;
                    if (emojis[i] == null) continue;
                    float x = (float)(this.categorySelectionArea.func_199318_a() + this.categorySelectionArea.func_199316_c() + 2) + 12.0f * (float)i;
                    Rectangle2d rec = new Rectangle2d((int)x, (int)(y = (float)this.categorySelectionArea.func_199319_b() + height + 2.0f) - 1, 11, 11);
                    if (rec.func_199315_b((int)this.lastMouseX, (int)this.lastMouseY)) {
                        this.lastEmoji = emojis[i];
                        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(rec.func_199318_a() - 1), (int)(rec.func_199319_b() - 1), (int)(rec.func_199318_a() + rec.func_199316_c()), (int)(rec.func_199319_b() + rec.func_199317_d()), (int)-2130706433);
                    }
                    Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, emojis[i].strings.get(0), x, y, 0x969696);
                }
            }
        }
    }

    public Object getLineToDraw(int line) {
        if (this.fieldWidget.func_146179_b().isEmpty()) {
            for (EmojiCategory category : ClientProxy.SORTED_EMOJIS_FOR_SELECTION.keySet()) {
                if (--line == 0) {
                    return category;
                }
                for (Emoji[] emojis : ClientProxy.SORTED_EMOJIS_FOR_SELECTION.get(category)) {
                    if (--line != 0) continue;
                    return emojis;
                }
            }
        } else if (this.filteredEmojis.size() > line - 1 && line - 1 >= 0) {
            return this.filteredEmojis.get(line - 1);
        }
        return null;
    }

    public void updateFilter() {
        if (!this.fieldWidget.func_146179_b().isEmpty()) {
            this.selectionPointer = 1;
            this.filteredEmojis = new ArrayList<Emoji[]>();
            List emojis = Emojiful.EMOJI_LIST.stream().filter(emoji -> emoji.strings.stream().anyMatch(s -> s.toLowerCase().contains(this.fieldWidget.func_146179_b().toLowerCase()))).collect(Collectors.toList());
            Emoji[] array = new Emoji[9];
            int i = 0;
            Iterator iterator = emojis.iterator();
            while (iterator.hasNext()) {
                Emoji emoji2;
                array[i] = emoji2 = (Emoji)iterator.next();
                if (++i < array.length) continue;
                this.filteredEmojis.add(array);
                array = new Emoji[9];
                i = 0;
            }
            if (i > 0) {
                this.filteredEmojis.add(array);
            }
        }
    }

    public int getLineAmount() {
        return this.fieldWidget.func_146179_b().isEmpty() ? ClientProxy.lineAmount : this.filteredEmojis.size();
    }

    public EmojiCategory getCategory(int line) {
        for (EmojiCategory category : ClientProxy.SORTED_EMOJIS_FOR_SELECTION.keySet()) {
            if (--line == 0) {
                return category;
            }
            for (Emoji[] emojis : ClientProxy.SORTED_EMOJIS_FOR_SELECTION.get(category)) {
                if (--line != 0) continue;
                return category;
            }
        }
        return null;
    }

    public ChatScreen getChatScreen() {
        return this.chatScreen;
    }

    public TextFieldWidget getFieldWidget() {
        return this.fieldWidget;
    }
}

