/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful;

import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;

public class EmojifulConfig {
    private static EmojifulConfig instance;
    public ForgeConfigSpec.BooleanValue renderEmoji;
    public ForgeConfigSpec.BooleanValue showEmojiSelector;
    public ForgeConfigSpec.BooleanValue showEmojiAutocomplete;
    public ForgeConfigSpec.BooleanValue loadTwemoji;
    public ForgeConfigSpec.BooleanValue loadCustom;
    public ForgeConfigSpec.BooleanValue loadDatapack;
    public ForgeConfigSpec.BooleanValue loadGifEmojis;
    public ForgeConfigSpec.BooleanValue shortEmojiReplacement;
    public ForgeConfigSpec.BooleanValue profanityFilter;
    public ForgeConfigSpec.ConfigValue<String> profanityFilterReplacement;
    private final ForgeConfigSpec spec;

    private EmojifulConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Emojiful");
        this.renderEmoji = builder.comment("Enable Emoji Rendering").define("enabled", true);
        this.showEmojiSelector = builder.comment("Enable Emoji Selection GUI in the chat text line").define("emoji_selector", true);
        this.showEmojiAutocomplete = builder.comment("Enable Emoji autocomplete in the chat text line").define("emoji_autocomplete", true);
        this.loadGifEmojis = builder.comment("Load animated emojis, if disabled they will be a still image").define("gifs", true);
        this.shortEmojiReplacement = builder.comment("Replace short versions of emoji like :) into :smile: so they can be rendered as emoji").define("short_emoji_replacement", true);
        builder.push("EmojiTypes");
        this.loadTwemoji = builder.comment("Loads Twemojis used in sites like Twitter and Discord").define("twemoji", true);
        this.loadCustom = builder.comment("Loads custom emojis provided by Emojiful").define("custom", true);
        this.loadDatapack = builder.comment("Loads datapack emojis provided by the server you join").define("datapack", true);
        builder.pop();
        builder.pop();
        builder.push("ProfanityFilter");
        this.profanityFilter = builder.comment("Enable Profanity Filter, this will replace bad words with emoji").define("enabled", false);
        this.profanityFilterReplacement = builder.comment("Replacement word for the profanity filter").define("replacement", (Object)":swear:");
        builder.pop();
        this.spec = builder.build();
    }

    public static ForgeConfigSpec init() {
        EmojifulConfig config;
        instance = config = new EmojifulConfig(new ForgeConfigSpec.Builder());
        return config.getSpec();
    }

    public static EmojifulConfig getInstance() {
        return Objects.requireNonNull(instance, "Called for Config before it's Initialization");
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }
}

