/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.light;

import com.jozufozu.flywheel.light.GridAlignedBB;
import com.jozufozu.flywheel.light.ILightUpdateListener;
import com.jozufozu.flywheel.util.WeakHashSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import java.util.WeakHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;

public class LightUpdater {
    private static LightUpdater instance;
    private final Long2ObjectMap<WeakHashSet<ILightUpdateListener>> sections = new Long2ObjectOpenHashMap();
    private final WeakHashMap<ILightUpdateListener, LongRBTreeSet> listenersToSections = new WeakHashMap();
    private final Long2ObjectMap<WeakHashSet<ILightUpdateListener>> chunks = new Long2ObjectOpenHashMap();
    private final WeakHashMap<ILightUpdateListener, LongRBTreeSet> listenersToChunks = new WeakHashMap();

    public static LightUpdater getInstance() {
        if (instance == null) {
            instance = new LightUpdater();
        }
        return instance;
    }

    public void startListening(BlockPos pos, ILightUpdateListener listener) {
        LongRBTreeSet sections = this.clearSections(listener);
        LongRBTreeSet chunks = this.clearChunks(listener);
        long sectionPos = LightUpdater.worldToSection(pos);
        this.addToSection(sectionPos, listener);
        sections.add(sectionPos);
        long chunkPos = LightUpdater.sectionToChunk(sectionPos);
        this.addToChunk(chunkPos, listener);
        chunks.add(chunkPos);
    }

    public void startListening(GridAlignedBB volume, ILightUpdateListener listener) {
        LongRBTreeSet sections = this.clearSections(listener);
        LongRBTreeSet chunks = this.clearSections(listener);
        int minX = SectionPos.func_218159_a((int)volume.minX);
        int minY = SectionPos.func_218159_a((int)volume.minY);
        int minZ = SectionPos.func_218159_a((int)volume.minZ);
        int maxX = SectionPos.func_218159_a((int)volume.maxX);
        int maxY = SectionPos.func_218159_a((int)volume.maxY);
        int maxZ = SectionPos.func_218159_a((int)volume.maxZ);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    long sectionPos = SectionPos.func_218166_b((int)x, (int)y, (int)z);
                    this.addToSection(sectionPos, listener);
                    sections.add(sectionPos);
                }
                long chunkPos = SectionPos.func_218166_b((int)x, (int)0, (int)z);
                this.addToChunk(chunkPos, listener);
                chunks.add(chunkPos);
            }
        }
    }

    public void onLightUpdate(IBlockDisplayReader world, LightType type, long sectionPos) {
        WeakHashSet set = (WeakHashSet)this.sections.get(sectionPos);
        if (set == null || set.isEmpty()) {
            return;
        }
        GridAlignedBB chunkBox = GridAlignedBB.from(SectionPos.func_218170_a((long)sectionPos));
        set.removeIf(listener -> listener.onLightUpdate(world, type, chunkBox.copy()));
    }

    public void onLightPacket(IBlockDisplayReader world, int chunkX, int chunkZ) {
        long chunkPos = SectionPos.func_218166_b((int)chunkX, (int)0, (int)chunkZ);
        WeakHashSet set = (WeakHashSet)this.chunks.get(chunkPos);
        if (set == null || set.isEmpty()) {
            return;
        }
        set.removeIf(listener -> listener.onLightPacket(world, chunkX, chunkZ));
    }

    private LongRBTreeSet clearChunks(ILightUpdateListener listener) {
        return this.clear(listener, this.listenersToChunks, this.chunks);
    }

    private LongRBTreeSet clearSections(ILightUpdateListener listener) {
        return this.clear(listener, this.listenersToSections, this.sections);
    }

    private LongRBTreeSet clear(ILightUpdateListener listener, WeakHashMap<ILightUpdateListener, LongRBTreeSet> listeners, Long2ObjectMap<WeakHashSet<ILightUpdateListener>> lookup) {
        LongRBTreeSet set = listeners.get(listener);
        if (set == null) {
            set = new LongRBTreeSet();
            listeners.put(listener, set);
        } else {
            set.forEach(l -> {
                WeakHashSet listeningSections = (WeakHashSet)lookup.get(l);
                if (listeningSections != null) {
                    listeningSections.remove(listener);
                }
            });
            set.clear();
        }
        return set;
    }

    private void addToSection(long sectionPos, ILightUpdateListener listener) {
        this.getOrCreate(this.sections, sectionPos).add(listener);
    }

    private void addToChunk(long chunkPos, ILightUpdateListener listener) {
        this.getOrCreate(this.chunks, chunkPos).add(listener);
    }

    private WeakHashSet<ILightUpdateListener> getOrCreate(Long2ObjectMap<WeakHashSet<ILightUpdateListener>> sections, long chunkPos) {
        WeakHashSet set = (WeakHashSet)sections.get(chunkPos);
        if (set == null) {
            set = new WeakHashSet();
            sections.put(chunkPos, set);
        }
        return set;
    }

    public static long worldToSection(BlockPos pos) {
        return SectionPos.func_218166_b((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }

    public static long sectionToChunk(long sectionPos) {
        return sectionPos & 0xFFFFFFFFFFF00000L;
    }
}

