/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.event;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.state.RenderLayer;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.eventbus.api.Event;

public class RenderLayerEvent
extends Event {
    private final ClientWorld world;
    public final RenderType type;
    public final MatrixStack stack;
    public final Matrix4f viewProjection;
    public final RenderTypeBuffers buffers;
    public final double camX;
    public final double camY;
    public final double camZ;
    public final RenderLayer layer;

    public RenderLayerEvent(ClientWorld world, RenderType type, MatrixStack stack, RenderTypeBuffers buffers, double camX, double camY, double camZ) {
        this.world = world;
        this.type = type;
        this.stack = stack;
        this.viewProjection = stack.func_227866_c_().func_227870_a_().func_226601_d_();
        this.viewProjection.multiplyBackward(Backend.getInstance().getProjectionMatrix());
        this.buffers = buffers;
        this.camX = camX;
        this.camY = camY;
        this.camZ = camZ;
        this.layer = RenderLayer.fromRenderType(type);
    }

    @Nullable
    public RenderLayer getLayer() {
        return this.layer;
    }

    public ClientWorld getWorld() {
        return this.world;
    }

    public RenderType getType() {
        return this.type;
    }

    public Matrix4f getViewProjection() {
        return this.viewProjection;
    }

    public double getCamX() {
        return this.camX;
    }

    public double getCamY() {
        return this.camY;
    }

    public double getCamZ() {
        return this.camZ;
    }
}

