/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.shader.GlFog;
import com.jozufozu.flywheel.core.shader.extension.IExtensionInstance;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public abstract class FogMode {

    public static class Exp2
    implements IExtensionInstance {
        public static final ResourceLocation NAME = new ResourceLocation("flywheel", "fog_exp2");
        private final int uFogColor;
        private final int uFogDensity;

        public Exp2(GlProgram program) {
            this.uFogColor = program.getUniformLocation("uFogColor");
            this.uFogDensity = program.getUniformLocation("uFogDensity");
        }

        @Override
        public void bind() {
            GL20.glUniform1f((int)this.uFogDensity, (float)GlFog.getFogDensity());
            GL20.glUniform4fv((int)this.uFogColor, (float[])GlFog.FOG_COLOR);
        }

        @Override
        public ResourceLocation name() {
            return NAME;
        }
    }

    public static class Linear
    implements IExtensionInstance {
        public static final ResourceLocation NAME = new ResourceLocation("flywheel", "fog_linear");
        private final int uFogColor;
        private final int uFogRange;

        public Linear(GlProgram program) {
            this.uFogColor = program.getUniformLocation("uFogColor");
            this.uFogRange = program.getUniformLocation("uFogRange");
        }

        @Override
        public void bind() {
            GL20.glUniform2f((int)this.uFogRange, (float)GlFog.getFogStart(), (float)GlFog.getFogEnd());
            GL20.glUniform4fv((int)this.uFogColor, (float[])GlFog.FOG_COLOR);
        }

        @Override
        public ResourceLocation name() {
            return NAME;
        }
    }
}

