/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.loading;

import com.jozufozu.flywheel.backend.loading.LayoutTag;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaggedField {
    public static final Pattern fieldPattern = Pattern.compile("(?:#\\[([^\\n]*)]\\s*)?(\\S+)\\s*(\\S+);");
    public String annotation;
    public String name;
    public String type;
    public LayoutTag layout;

    public TaggedField(Matcher fieldMatcher) {
        Matcher matcher;
        this.annotation = fieldMatcher.group(1);
        this.type = fieldMatcher.group(2);
        this.name = fieldMatcher.group(3);
        if (this.annotation != null && (matcher = LayoutTag.pattern.matcher(this.annotation)).find()) {
            this.layout = new LayoutTag(matcher);
        }
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "TaggedField{name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

