/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import net.minecraft.util.Direction;

public class Position2D {
    public final int x;
    public final int z;

    public Position2D(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public boolean isValid(int xBound, int zBound) {
        return this.x > -1 && this.z > -1 && this.x < xBound && this.z < zBound;
    }

    public boolean isValid(int bound) {
        return this.x > -1 && this.z > -1 && this.x < bound && this.z < bound;
    }

    public Direction directionTo(int x, int z) {
        if (x > this.x) {
            return Direction.EAST;
        }
        if (x < this.x) {
            return Direction.WEST;
        }
        if (z > this.z) {
            return Direction.SOUTH;
        }
        if (z < this.z) {
            return Direction.NORTH;
        }
        return null;
    }

    public Direction directionTo(Position2D pos) {
        if (pos.x > this.x) {
            return Direction.EAST;
        }
        if (pos.x < this.x) {
            return Direction.WEST;
        }
        if (pos.z > this.z) {
            return Direction.SOUTH;
        }
        if (pos.z < this.z) {
            return Direction.NORTH;
        }
        throw new IllegalArgumentException("The target position must not be equal to the origin position.");
    }

    public static boolean isValid(int x, int z, int xBound, int zBound) {
        return x >= 0 && z >= 0 && x < xBound && z < zBound;
    }

    public static boolean isValid(int x, int z, int bound) {
        return x >= 0 && z >= 0 && x < bound && z < bound;
    }

    public Position2D shift(Direction direction, int amount) {
        switch (direction) {
            case NORTH: {
                return new Position2D(this.x, this.z - amount);
            }
            case EAST: {
                return new Position2D(this.x + amount, this.z);
            }
            case SOUTH: {
                return new Position2D(this.x, this.z + amount);
            }
            case WEST: {
                return new Position2D(this.x - amount, this.z);
            }
        }
        return this;
    }
}

