/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.block.provider.SingleBlock;
import xiroc.dungeoncrawl.dungeon.block.provider.WeightedRandomBlock;
import xiroc.dungeoncrawl.dungeon.block.provider.pattern.CheckerboardPattern;
import xiroc.dungeoncrawl.dungeon.block.provider.pattern.TerracottaPattern;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class JsonTheming {
    protected static Theme deserializeTheme(JsonObject object, ResourceLocation file) {
        JsonObject themeObject = object.get("theme").getAsJsonObject();
        Theme.Builder themeBuilder = Theme.builder();
        themeBuilder.solid(JsonTheming.deserialize(themeObject, "solid", file)).generic(JsonTheming.deserialize(themeObject, "generic", file)).pillar(JsonTheming.deserialize(themeObject, "pillar", file)).fencing(JsonTheming.deserialize(themeObject, "fencing", file)).floor(JsonTheming.deserialize(themeObject, "floor", file)).fluid(JsonTheming.deserialize(themeObject, "fluid", file)).material(JsonTheming.deserialize(themeObject, "material", file)).stairs(JsonTheming.deserialize(themeObject, "stairs", file)).solidStairs(JsonTheming.deserialize(themeObject, "solid_stairs", file)).slab(JsonTheming.deserialize(themeObject, "slab", file)).solidSlab(JsonTheming.deserialize(themeObject, "solid_slab", file)).wall(JsonTheming.deserialize(themeObject, "wall", file));
        if (object.has("decorations")) {
            object.getAsJsonArray("decorations").forEach(element -> themeBuilder.addDecoration(DungeonDecoration.fromJson(element.getAsJsonObject(), file)));
        }
        if (object.has("secondary_theme")) {
            WeightedRandom.Builder builder = new WeightedRandom.Builder();
            object.getAsJsonArray("secondary_theme").forEach(element -> {
                JsonObject instance = element.getAsJsonObject();
                ResourceLocation key = new ResourceLocation(instance.get("key").getAsString());
                if (!Theme.KEY_TO_SECONDARY_THEME.containsKey(key)) {
                    throw new DatapackLoadException("Unknown secondary theme key " + key + " in " + file.toString());
                }
                builder.add(Theme.KEY_TO_SECONDARY_THEME.get(key), JSONUtils.getWeight(instance));
            });
            themeBuilder.secondaryTheme(builder.build());
        }
        if (object.has("id")) {
            int id = object.get("id").getAsInt();
            themeBuilder.legacyId(id);
        }
        return themeBuilder.build();
    }

    protected static SecondaryTheme deserializeSecondaryTheme(JsonObject object, ResourceLocation file) {
        JsonObject themeObject = object.get("theme").getAsJsonObject();
        SecondaryTheme.Builder themeBuilder = SecondaryTheme.builder();
        themeBuilder.pillar(JsonTheming.deserialize(themeObject, "pillar", file)).trapdoor(JsonTheming.deserialize(themeObject, "trapdoor", file)).door(JsonTheming.deserialize(themeObject, "door", file)).material(JsonTheming.deserialize(themeObject, "material", file)).stairs(JsonTheming.deserialize(themeObject, "stairs", file)).slab(JsonTheming.deserialize(themeObject, "slab", file)).fence(JsonTheming.deserialize(themeObject, "fence", file)).fenceGate(JsonTheming.deserialize(themeObject, "fence_gate", file)).button(JsonTheming.deserialize(themeObject, "button", file)).pressurePlate(JsonTheming.deserialize(themeObject, "pressure_plate", file));
        if (object.has("id")) {
            themeBuilder.legacyId(object.get("id").getAsInt());
        }
        return themeBuilder.build();
    }

    protected static void deserializeThemeMapping(JsonObject object, Map<String, WeightedRandom.Builder<Theme>> themeMappingBuilders, WeightedRandom.Builder<Theme> defaultBuilder, ResourceLocation file) {
        if (JSONUtils.areRequirementsMet(object)) {
            object.getAsJsonObject("mapping").entrySet().forEach(entry -> {
                ArrayList<Tuple<ResourceLocation, Integer>> entries = JsonTheming.checkAndListThemes(entry);
                entries.forEach((Consumer<Tuple<ResourceLocation, Integer>>)((Consumer<Tuple>)tuple -> {
                    if (!Theme.KEY_TO_THEME.containsKey(tuple.func_76341_a())) {
                        throw new DatapackLoadException("Cannot resolve theme key " + tuple.func_76341_a() + " in " + file.toString());
                    }
                    themeMappingBuilders.computeIfAbsent((String)entry.getKey(), key -> new WeightedRandom.Builder()).add(Theme.KEY_TO_THEME.get(tuple.func_76341_a()), (Integer)tuple.func_76340_b());
                }));
            });
            if (object.has("default")) {
                object.getAsJsonArray("default").forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    ResourceLocation theme = new ResourceLocation(entry.get("key").getAsString());
                    if (!Theme.KEY_TO_THEME.containsKey(theme)) {
                        throw new DatapackLoadException("Cannot resolve theme key " + theme + " in the default case of " + file);
                    }
                    defaultBuilder.add(Theme.KEY_TO_THEME.get(theme), JSONUtils.getWeight(entry));
                });
            }
        }
    }

    protected static void deserializeSecondaryThemeMapping(JsonObject object, Map<String, WeightedRandom.Builder<SecondaryTheme>> secondaryThemeMappingBuilders, WeightedRandom.Builder<SecondaryTheme> defaultBuilder, ResourceLocation file) {
        if (JSONUtils.areRequirementsMet(object)) {
            object.getAsJsonObject("mapping").entrySet().forEach(entry -> {
                ArrayList<Tuple<ResourceLocation, Integer>> entries = JsonTheming.checkAndListThemes(entry);
                entries.forEach((Consumer<Tuple<ResourceLocation, Integer>>)((Consumer<Tuple>)tuple -> {
                    if (!Theme.KEY_TO_SECONDARY_THEME.containsKey(tuple.func_76341_a())) {
                        throw new DatapackLoadException("Cannot resolve secondary theme key " + tuple.func_76341_a() + " in " + file.toString());
                    }
                    secondaryThemeMappingBuilders.computeIfAbsent((String)entry.getKey(), key -> new WeightedRandom.Builder()).add(Theme.KEY_TO_SECONDARY_THEME.get(tuple.func_76341_a()), (Integer)tuple.func_76340_b());
                }));
            });
            if (object.has("default")) {
                object.getAsJsonArray("default").forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    ResourceLocation theme = new ResourceLocation(entry.get("key").getAsString());
                    if (!Theme.KEY_TO_SECONDARY_THEME.containsKey(theme)) {
                        throw new DatapackLoadException("Cannot resolve secondary theme key " + theme + " in the default case of " + file);
                    }
                    defaultBuilder.add(Theme.KEY_TO_SECONDARY_THEME.get(theme), JSONUtils.getWeight(entry));
                });
            }
        }
    }

    private static ArrayList<Tuple<ResourceLocation, Integer>> checkAndListThemes(Map.Entry<String, JsonElement> entry) {
        if (!ForgeRegistries.BIOMES.containsKey(new ResourceLocation(entry.getKey()))) {
            DungeonCrawl.LOGGER.warn("The biome {} does not exist.", (Object)entry.getKey());
        }
        ArrayList<Tuple<ResourceLocation, Integer>> entries = new ArrayList<Tuple<ResourceLocation, Integer>>();
        entry.getValue().getAsJsonArray().forEach(element -> {
            JsonObject jsonObject = element.getAsJsonObject();
            entries.add(new Tuple((Object)new ResourceLocation(jsonObject.get("key").getAsString()), (Object)JSONUtils.getWeight(jsonObject)));
        });
        return entries;
    }

    protected static void deserializeRandomThemeFile(JsonObject object, WeightedRandom.Builder<Theme> themes, WeightedRandom.Builder<SecondaryTheme> secondaryThemes, ResourceLocation file) {
        if (JSONUtils.areRequirementsMet(object)) {
            if (object.has("primary_themes")) {
                object.getAsJsonArray("primary_themes").forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    ResourceLocation key = new ResourceLocation(entry.get("key").getAsString());
                    if (!Theme.KEY_TO_THEME.containsKey(key)) {
                        throw new DatapackLoadException("Cannot resolve primary theme key " + key + " in " + file);
                    }
                    themes.add(Theme.KEY_TO_THEME.get(key), JSONUtils.getWeight(entry));
                });
            }
            if (object.has("secondary_themes")) {
                object.getAsJsonArray("secondary_themes").forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    ResourceLocation key = new ResourceLocation(entry.get("key").getAsString());
                    if (!Theme.KEY_TO_SECONDARY_THEME.containsKey(key)) {
                        throw new DatapackLoadException("Cannot resolve secondary theme key " + key + " in " + file);
                    }
                    secondaryThemes.add(Theme.KEY_TO_SECONDARY_THEME.get(key), JSONUtils.getWeight(entry));
                });
            }
        }
    }

    public static BlockStateProvider deserialize(JsonObject base, String name, ResourceLocation file) {
        if (!base.has(name)) {
            DungeonCrawl.LOGGER.warn("Missing BlockState Provider \"{}\" in {}", (Object)name, (Object)file.toString());
            return null;
        }
        JsonObject object = (JsonObject)base.get(name);
        if (object.has("type")) {
            String type = object.get("type").getAsString();
            if (type.equalsIgnoreCase("random_block")) {
                JsonArray blockObjects = object.get("blocks").getAsJsonArray();
                WeightedRandom.Builder<BlockState> builder = new WeightedRandom.Builder<BlockState>();
                for (JsonElement blockElement : blockObjects) {
                    JsonObject blockObject = (JsonObject)blockElement;
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockObject.get("block").getAsString()));
                    if (block != null) {
                        BlockState state = JSONUtils.deserializeBlockStateProperties(block, blockObject);
                        builder.add(state, JSONUtils.getWeight(blockObject));
                        continue;
                    }
                    DungeonCrawl.LOGGER.error("Unknown block: {}", (Object)blockObject.get("block").getAsString());
                }
                return new WeightedRandomBlock(builder.build());
            }
            if (type.equalsIgnoreCase("block")) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(object.get("block").getAsString()));
                if (block != null) {
                    BlockState state = JSONUtils.deserializeBlockStateProperties(block, object);
                    return new SingleBlock(state);
                }
                DungeonCrawl.LOGGER.error("Unknown block: {}", (Object)object.get("block").getAsString());
                return new SingleBlock(Blocks.field_201941_jj.func_176223_P());
            }
            if (type.equalsIgnoreCase("pattern")) {
                switch (object.get("pattern_type").getAsString().toLowerCase(Locale.ROOT)) {
                    case "checkerboard": {
                        return new CheckerboardPattern(JsonTheming.deserialize(object, "block_1", file), JsonTheming.deserialize(object, "block_2", file));
                    }
                    case "terracotta": {
                        return new TerracottaPattern(JsonTheming.deserialize(object, "block", file));
                    }
                }
                DungeonCrawl.LOGGER.error("Unknown block pattern type: " + object.get("pattern_type").getAsString());
                return null;
            }
            DungeonCrawl.LOGGER.error("Failed to load BlockState Provider {}: Unknown type {}.", (Object)object, (Object)type);
            return null;
        }
        DungeonCrawl.LOGGER.error("Invalid BlockState Provider \"{}\": Type not specified.", (Object)name);
        return null;
    }
}

