/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import xiroc.dungeoncrawl.DungeonCrawl;

public class SpawnRates {
    private static RandomValueRange[] DELAY;
    private static RandomValueRange[] AMOUNT;

    public static RandomValueRange getAmount(int level) {
        if (level < 0) {
            return AMOUNT[0];
        }
        if (level > 4) {
            return AMOUNT[4];
        }
        return AMOUNT[level];
    }

    public static RandomValueRange getDelay(int level) {
        if (level < 0) {
            return DELAY[0];
        }
        if (level > 4) {
            return DELAY[4];
        }
        return DELAY[level];
    }

    public static void loadJson(IResourceManager resourceManager) {
        DELAY = new RandomValueRange[5];
        AMOUNT = new RandomValueRange[5];
        ResourceLocation resource = DungeonCrawl.locate("monster/spawn_rates.json");
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource.toString());
        try {
            if (!resourceManager.func_219533_b(resource)) {
                throw new FileNotFoundException("Missing file " + resource);
            }
            JsonObject data = new JsonParser().parse((Reader)new InputStreamReader(resourceManager.func_199002_a(resource).func_199027_b())).getAsJsonObject();
            SpawnRates.loadLevel(data, resource, 0);
            SpawnRates.loadLevel(data, resource, 1);
            SpawnRates.loadLevel(data, resource, 2);
            SpawnRates.loadLevel(data, resource, 3);
            SpawnRates.loadLevel(data, resource, 4);
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("An error occurred whilst trying to load {}", (Object)resource.toString());
            e.printStackTrace();
        }
    }

    private static void loadLevel(JsonObject object, ResourceLocation resource, int level) {
        String entry = "level_" + (level + 1);
        if (object.has(entry)) {
            JsonObject data = object.getAsJsonObject(entry);
            JsonObject delay = data.getAsJsonObject("delay");
            JsonObject amount = data.getAsJsonObject("amount");
            SpawnRates.DELAY[level] = new RandomValueRange((float)delay.get("min").getAsInt(), (float)delay.get("max").getAsInt());
            SpawnRates.AMOUNT[level] = new RandomValueRange((float)amount.get("min").getAsInt(), (float)amount.get("max").getAsInt());
        } else {
            DungeonCrawl.LOGGER.warn("Missing entry {} in {}", (Object)entry, (Object)resource.toString());
            SpawnRates.DELAY[level] = new RandomValueRange(200.0f, 180.0f);
            SpawnRates.AMOUNT[level] = new RandomValueRange(1.0f, 3.0f);
        }
    }
}

